/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dragndrop;

import de.duehl.basics.logic.ErrorHandler;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dragndrop.ChangeInformer;
import de.duehl.swing.ui.dragndrop.StandardTextComponentDropTargetListener;
import de.duehl.swing.ui.timer.WaitingUserInputTimerOperator;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditorUiElementManager
extends WaitingUserInputTimerOperator {
    private static final int MILLISECONDS_BEFORE_REFRESH = 250;
    protected final ErrorHandler error;
    protected final ChangeInformer changeInformer;

    public EditorUiElementManager(ErrorHandler errorHandler, ChangeInformer changeInformer) {
        this(errorHandler, changeInformer, 250);
    }

    public EditorUiElementManager(ErrorHandler errorHandler, ChangeInformer changeInformer, int n) {
        super(n);
        this.error = errorHandler;
        this.changeInformer = changeInformer;
    }

    public void addChangeListenerAndDragNDropCorrectorToTextField(JTextField jTextField) {
        this.addDragNDropCorrectorToTextField(jTextField);
        this.addChangeListenerToTextField(jTextField);
    }

    public void addChangeListenerAndDragNDropCorrectorToTextArea(JTextArea jTextArea) {
        this.addDragNDropCorrectorToTextArea(jTextArea);
        this.addChangeListenerToTextArea(jTextArea);
    }

    public void addChangeListenerAndDragNDropCorrectorToComboBox(JComboBox<String> jComboBox) {
        this.addDragNDropCorrectorToComboBox(jComboBox);
        this.addChangeListenerToComboBox(jComboBox);
    }

    private void addDragNDropCorrectorToTextField(JTextField jTextField) {
        GuiTools.addDropTargetListenerToTextField(jTextField, this.error, new StandardTextComponentDropTargetListener(jTextField));
    }

    private void addDragNDropCorrectorToTextArea(JTextArea jTextArea) {
        GuiTools.addDropTargetListenerToTextArea(jTextArea, this.error, new StandardTextComponentDropTargetListener(jTextArea));
    }

    private void addDragNDropCorrectorToComboBox(JComboBox<String> jComboBox) {
        JTextField jTextField = GuiTools.getTextFieldInComboBox(jComboBox);
        this.addDragNDropCorrectorToTextField(jTextField);
    }

    protected final void addChangeListenerToTextField(JTextField jTextField) {
        jTextField.getDocument().addDocumentListener(this.createChangeDocumentListener());
    }

    protected final void addChangeListenerToTextArea(JTextArea jTextArea) {
        jTextArea.getDocument().addDocumentListener(this.createChangeDocumentListener());
    }

    private void addChangeListenerToComboBox(JComboBox<String> jComboBox) {
        JTextField jTextField = GuiTools.getTextFieldInComboBox(jComboBox);
        this.addChangeListenerToTextField(jTextField);
    }

    private DocumentListener createChangeDocumentListener() {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.warnAboutUserInput();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.warnAboutUserInput();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.warnAboutUserInput();
            }

            private void warnAboutUserInput() {
                EditorUiElementManager.this.startTimer();
            }
        };
    }

    @Override
    protected final Runnable createRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(() -> EditorUiElementManager.this.changeInformer.informAboutChangingData());
            }
        };
    }
}

