/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.filter.dialog;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.FineFileWriter;
import de.duehl.basics.io.textfile.FullNormalTextFileReader;
import de.duehl.basics.logic.ErrorHandler;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.filefilter.FilterFileFilter;
import de.duehl.swing.ui.filter.dialog.FilterCombinationLine;
import de.duehl.swing.ui.filter.dialog.FilterCombinationLineHandler;
import de.duehl.swing.ui.filter.dialog.creation.RealFilterCreater;
import de.duehl.swing.ui.filter.exceptions.FilterException;
import de.duehl.swing.ui.filter.method.FilterMethodFabricable;
import de.duehl.swing.ui.filter.project.gateway.FilterGateway;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class FilterCombinationDialog<Data, Type>
extends ModalDialogBase
implements FilterCombinationLineHandler<Data, Type> {
    private static final Dimension DIALOG_DIMENSION = new Dimension(850, 550);
    private static final String DEFAULT_SAVE_FILTER_FILENAME = "DEFAULT_SAVE_FILTER.filter";
    private final FilterGateway<Data, Type> gateway;
    private final FilterMethodFabricable<Data, Type> methodFabric;
    private final String filterPath;
    private final ErrorHandler error;
    private final String saveFileName;
    private final List<FilterCombinationLine<Data, Type>> lines;
    private final JPanel combinationPanel;
    private boolean errorOccured;

    public FilterCombinationDialog(Point point, Image image, FilterGateway<Data, Type> filterGateway, FilterMethodFabricable<Data, Type> filterMethodFabricable, String string, ErrorHandler errorHandler) {
        super(point, image, "Filterkombinationen", DIALOG_DIMENSION);
        this.gateway = filterGateway;
        this.methodFabric = filterMethodFabricable;
        this.filterPath = string;
        this.error = errorHandler;
        this.saveFileName = FileHelper.concatPathes(string, DEFAULT_SAVE_FILTER_FILENAME);
        this.lines = new ArrayList<FilterCombinationLine<Data, Type>>();
        this.combinationPanel = new JPanel();
        this.initElements();
        this.fillDialog();
        this.load(this.saveFileName);
    }

    private void initElements() {
        this.combinationPanel.setLayout(new VerticalLayout(5, 2));
    }

    @Override
    protected void populateDialog() {
        this.add(this.createBuildPart(), "North");
        this.add(new JScrollPane(this.combinationPanel), "Center");
        this.add(this.createButtonPart(), "South");
    }

    private Component createBuildPart() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.createLeftBuildPanel(), "West");
        return jPanel;
    }

    private Component createLeftBuildPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.createNewLineButton());
        jPanel.add(this.createClearAllButton());
        return jPanel;
    }

    private Component createNewLineButton() {
        JButton jButton = new JButton("neue Zeile");
        jButton.addActionListener(actionEvent -> this.newLine());
        return jButton;
    }

    private void newLine() {
        FilterCombinationLine<Data, Type> filterCombinationLine = new FilterCombinationLine<Data, Type>(this.combinationPanel, this.lines.size(), this.gateway, this);
        this.validate();
        this.lines.add(filterCombinationLine);
    }

    private Component createClearAllButton() {
        JButton jButton = new JButton("alles l\u00f6schen");
        jButton.addActionListener(actionEvent -> this.clearAll());
        return jButton;
    }

    private void clearAll() {
        this.combinationPanel.removeAll();
        this.lines.clear();
        this.combinationPanel.validate();
        this.validate();
        this.repaint();
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createRightButtonPart(), "East");
        jPanel.add((Component)this.createLeftButtonPart(), "West");
        return jPanel;
    }

    private JPanel createLeftButtonPart() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.createLoadButton());
        jPanel.add(this.createSaveButton());
        return jPanel;
    }

    private JButton createLoadButton() {
        JButton jButton = new JButton("Laden");
        jButton.addActionListener(actionEvent -> this.load());
        return jButton;
    }

    private JButton createSaveButton() {
        JButton jButton = new JButton("Speichern");
        jButton.addActionListener(actionEvent -> this.save());
        return jButton;
    }

    private JPanel createRightButtonPart() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.createCancelButton());
        jPanel.add(this.createApplyButton());
        return jPanel;
    }

    private JButton createCancelButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private JButton createApplyButton() {
        JButton jButton = new JButton("FIlter erzeugen");
        jButton.addActionListener(actionEvent -> this.applyButtonPressed());
        return jButton;
    }

    private void applyButtonPressed() {
        GuiTools.waitcursorImmediatelyOn(this.getDialog());
        boolean bl = this.checkFilter();
        if (bl) {
            try {
                this.tryToApply();
            }
            catch (FilterException filterException) {
                this.handleExceptionWhileApplying(filterException);
            }
        }
        GuiTools.waitcursorOff(this.getDialog());
    }

    private void tryToApply() {
        this.errorOccured = false;
        this.createRealFilter();
        if (this.errorOccured) {
            this.requestFocus();
        } else {
            this.save(this.saveFileName);
            if (this.gateway.isFilterCombinedMethods()) {
                this.closeDialog();
            } else {
                this.requestFocus();
            }
        }
    }

    private void createRealFilter() {
        try {
            this.tryToCreateRealFilter();
        }
        catch (Exception exception) {
            this.errorOccured = true;
            this.error.error("Fehler beim Erzeugen des echten Filters.", exception);
        }
    }

    private void handleExceptionWhileApplying(FilterException filterException) {
        StackTraceElement[] stackTraceElementArray = filterException.getStackTrace();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (++n > 5) {
                stringBuilder.append("...\n");
                break;
            }
            stringBuilder.append(stackTraceElement.getFileName() + " - " + stackTraceElement.getClassName() + " - " + stackTraceElement.getMethodName() + " - " + stackTraceElement.getLineNumber() + "\n");
        }
        this.error.warning("Bei der Erzeugung des Filters trat ein Fehler auf:\n\n" + filterException.getMessage() + "\n\nStacktrace: " + stringBuilder.toString());
    }

    private boolean checkFilter() {
        if (this.lines.size() < 1) {
            this.error.warning("Der Filte ist leer!");
            return false;
        }
        int n = 0;
        int n2 = 0;
        for (FilterCombinationLine<Data, Type> filterCombinationLine : this.lines) {
            String string;
            if (filterCombinationLine.isInStartPhase()) {
                this.error.warning("Mindestens eine Zeile ist noch im Start-Zustand!");
                return false;
            }
            if (filterCombinationLine.isMethodLine() || filterCombinationLine.isNegatedMethodLine()) {
                string = filterCombinationLine.getMethodComboBoxSelection();
                if (!string.equals("- bitte w\u00e4hlen -")) continue;
                this.error.warning("Bitte paramterlose Methode w\u00e4hlen!");
                return false;
            }
            if (filterCombinationLine.isParamisedMethodLine() || filterCombinationLine.isParamisedNegatedMethodLine()) {
                string = filterCombinationLine.getMethodComboBoxSelection();
                String string2 = filterCombinationLine.getParameter();
                if (!string.equals("- bitte w\u00e4hlen -") && !string2.isEmpty()) continue;
                this.error.warning("Bitte paramtrisierte Methode w\u00e4hlen!");
                return false;
            }
            if (filterCombinationLine.isBraceOpenLine() || filterCombinationLine.isNegatedBraceOpenLine()) {
                ++n;
                continue;
            }
            if (filterCombinationLine.isBraceCloseLine()) {
                ++n2;
                continue;
            }
            if (filterCombinationLine.isIntersectionLine() || filterCombinationLine.isUnionLine()) continue;
            this.error.warning("Unbekanntes FilterCombinationLine-Objekt: " + filterCombinationLine.getTypeAsString());
            return false;
        }
        if (n2 != n) {
            this.error.warning("Unterschiedliche Anzahl \u00f6ffnender und schlie\u00dfender Klammern.");
            return false;
        }
        return true;
    }

    private void tryToCreateRealFilter() {
        RealFilterCreater<Data, Type> realFilterCreater = new RealFilterCreater<Data, Type>(this.methodFabric, this.lines, this.gateway);
        this.gateway.setRealFilter(realFilterCreater.createRealFilter());
    }

    private void load() {
        String string = GuiTools.openFile(this.getDialog(), this.filterPath, (FileFilter)new FilterFileFilter());
        if (!string.isEmpty()) {
            this.load(string);
        }
    }

    private void load(String string) {
        this.lines.clear();
        this.combinationPanel.removeAll();
        if (FileHelper.isFile(string)) {
            this.loadExistingFile(string);
        }
        this.combinationPanel.validate();
        this.combinationPanel.repaint();
        this.validate();
        this.repaint();
    }

    private void loadExistingFile(String string) {
        try {
            this.tryToLloadExistingFile(string);
        }
        catch (Exception exception) {
            this.error.error("Fehler beim Laden des Filters aus der Datei\n\t" + string, exception);
        }
    }

    private void tryToLloadExistingFile(String string2) {
        FullNormalTextFileReader fullNormalTextFileReader = new FullNormalTextFileReader(string2, Charset.ISO_8859_1);
        fullNormalTextFileReader.setLineDescription("Zeile einer Filterdatei");
        fullNormalTextFileReader.setProgressTextStart("Einlesen der Filterdatei");
        fullNormalTextFileReader.beQuiet();
        fullNormalTextFileReader.read(string -> this.analyseLine(string, fullNormalTextFileReader.getLineNumber()));
    }

    private void analyseLine(String string, int n) {
        if (string.equals("")) {
            GuiTools.informUser(this.getDialog(), "Information", "Skipping empty line " + n);
        } else {
            FilterCombinationLine<Data, Type> filterCombinationLine = new FilterCombinationLine<Data, Type>(this.combinationPanel, this.lines.size(), this.gateway, this, string);
            this.lines.add(filterCombinationLine);
        }
    }

    private void save() {
        Object object = GuiTools.saveFileAs(this.getDialog(), this.filterPath, (FileFilter)new FilterFileFilter());
        if (!((String)object).isEmpty()) {
            if (!((String)object).endsWith(".filter")) {
                object = (String)object + ".filter";
            }
            this.save((String)object);
        }
    }

    private void save(String string) {
        try {
            this.tryToSave(string);
        }
        catch (Exception exception) {
            this.error.error("Fehler beim Speichern des Filters unter der Datei\n\t" + string, exception);
        }
    }

    private void tryToSave(String string) {
        FineFileWriter fineFileWriter = new FineFileWriter(string);
        for (FilterCombinationLine<Data, Type> filterCombinationLine : this.lines) {
            filterCombinationLine.write(fineFileWriter);
        }
        fineFileWriter.close();
    }

    @Override
    public void removeLine(FilterCombinationLine<Data, Type> filterCombinationLine) {
        int n = filterCombinationLine.getLineNumber();
        for (int i = n + 1; i < this.lines.size(); ++i) {
            FilterCombinationLine<Data, Type> filterCombinationLine2 = this.lines.get(i);
            filterCombinationLine2.setLineNumber(filterCombinationLine2.getLineNumber() - 1);
        }
        this.lines.remove(n);
        this.showAllLinesAgainInCombinationPanel();
    }

    @Override
    public void addLine(FilterCombinationLine<Data, Type> filterCombinationLine) {
        int n = filterCombinationLine.getLineNumber();
        for (int i = n + 1; i < this.lines.size(); ++i) {
            FilterCombinationLine<Data, Type> filterCombinationLine2 = this.lines.get(i);
            filterCombinationLine2.setLineNumber(filterCombinationLine2.getLineNumber() + 1);
        }
        FilterCombinationLine<Data, Type> filterCombinationLine3 = new FilterCombinationLine<Data, Type>(this.combinationPanel, n + 1, this.gateway, this);
        this.lines.add(n + 1, filterCombinationLine3);
        this.showAllLinesAgainInCombinationPanel();
    }

    private void showAllLinesAgainInCombinationPanel() {
        this.combinationPanel.removeAll();
        for (FilterCombinationLine<Data, Type> filterCombinationLine : this.lines) {
            this.combinationPanel.add(filterCombinationLine.getLinePanel());
            filterCombinationLine.validate();
        }
        this.combinationPanel.validate();
        this.combinationPanel.repaint();
        this.validate();
    }
}

