/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.syntax.highlighting;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.colors.NamedColorListFabric;
import de.duehl.swing.ui.highlightingeditor.syntax.HighlightingTokens;
import de.duehl.swing.ui.highlightingeditor.syntax.HighlightingType;
import de.duehl.swing.ui.highlightingeditor.syntax.SyntaxHighlighting;
import de.duehl.swing.ui.highlightingeditor.syntax.highlighting.Highlighting;
import java.awt.Color;
import java.util.List;

class WzPreparationHighlighting
implements Highlighting {
    private final SyntaxHighlighting sytaxHighlighting;

    WzPreparationHighlighting() {
        HighlightingType highlightingType = WzPreparationHighlighting.createKeywordHighlightingType();
        HighlightingType highlightingType2 = WzPreparationHighlighting.createSymbolHighlightingType();
        this.sytaxHighlighting = new SyntaxHighlighting(highlightingType, highlightingType2);
        this.addKeywords();
        this.addSymbols();
        this.addOther();
    }

    private static HighlightingType createKeywordHighlightingType() {
        return new HighlightingType(WzPreparationHighlighting.createColor("aubergine"), true);
    }

    private static HighlightingType createSymbolHighlightingType() {
        return new HighlightingType(WzPreparationHighlighting.createColor("forestgreen"), false, true);
    }

    private static Color createColor(String string) {
        return new NamedColorListFabric().getColorByName(string);
    }

    private void addKeywords() {
        List<String> list = CollectionsHelper.buildListFrom(new String[0]);
        for (String string : list) {
            this.sytaxHighlighting.addKeyword(string);
        }
    }

    private void addSymbols() {
        List<String> list = CollectionsHelper.buildListFrom(new String[0]);
        for (String string : list) {
            this.sytaxHighlighting.addSymbol(string);
        }
    }

    private void addOther() {
        this.addOther("gold", "i", "I");
        this.addOther("green", "l", "L");
        this.addOther("red", "0", "1");
        this.addOther("hotpink", "ae", "oe", "ue", "Ae", "Oe", "Ue");
        this.addOther("blue", "O", "o");
        this.addOther("darkmagenta", "ss");
    }

    private void addOther(String string, String ... stringArray) {
        HighlightingType highlightingType = new HighlightingType(WzPreparationHighlighting.createColor(string), true, true);
        HighlightingTokens highlightingTokens = new HighlightingTokens(highlightingType);
        for (String string2 : stringArray) {
            highlightingTokens.addToken(string2);
        }
        this.sytaxHighlighting.addOtherHighlightingTokens(highlightingTokens);
    }

    @Override
    public SyntaxHighlighting create() {
        return this.sytaxHighlighting;
    }
}

