/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.menu.collection;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.menu.collection.StoredMyMenuItem;
import de.duehl.swing.ui.menu.collection.tools.MyMenuItemCollectionHelper;
import java.util.ArrayList;
import java.util.List;

class MyMenuItemCollection {
    private final List<StoredMyMenuItem> collectedMyMenuItems = new ArrayList<StoredMyMenuItem>();
    private boolean collectMyMenuItems = true;

    MyMenuItemCollection() {
    }

    public void collect(StoredMyMenuItem storedMyMenuItem) {
        if (this.collectMyMenuItems) {
            this.collectedMyMenuItems.add(storedMyMenuItem);
        }
    }

    public void checkAccelerator(StoredMyMenuItem storedMyMenuItem) {
        this.checkNewMyMenuItemForKeyboardDuplicates(storedMyMenuItem);
    }

    private void checkNewMyMenuItemForKeyboardDuplicates(StoredMyMenuItem storedMyMenuItem) {
        if (storedMyMenuItem.isKeyCodeAndModifiersStored()) {
            for (StoredMyMenuItem storedMyMenuItem2 : this.collectedMyMenuItems) {
                if (storedMyMenuItem2 == storedMyMenuItem || !storedMyMenuItem2.isKeyCodeAndModifiersStored()) continue;
                this.checkNewMyMenuItemForKeyboardDuplicates(storedMyMenuItem, storedMyMenuItem2);
            }
        }
    }

    private void checkNewMyMenuItemForKeyboardDuplicates(StoredMyMenuItem storedMyMenuItem, StoredMyMenuItem storedMyMenuItem2) {
        if (storedMyMenuItem.getKeyCode() == storedMyMenuItem2.getKeyCode() && storedMyMenuItem.getModifiers() == storedMyMenuItem2.getModifiers()) {
            throw new IllegalArgumentException("Es gibt zwei Men\u00fceintr\u00e4ge mit dem gleichen Tastatur-Kommando:\n\tTastatur-Kommando    : '" + MyMenuItemCollectionHelper.generateKeyboardCommandDescription(storedMyMenuItem2) + "'\n\tVorhandener Men\u00fctext : '" + storedMyMenuItem2.getText() + "'\n\tNeuer Men\u00fctext       : '" + storedMyMenuItem.getText() + "'\n");
        }
    }

    public void switchOffMyMenuItemCollection() {
        this.collectMyMenuItems = false;
    }

    public void switchOnMyMenuItemCollection() {
        this.collectMyMenuItems = true;
    }

    public void clearCollection() {
        this.collectedMyMenuItems.clear();
    }

    public List<StoredMyMenuItem> getListOfCollectedMyMenuItems() {
        return CollectionsHelper.copyList(this.collectedMyMenuItems);
    }
}

