/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.menu.collection.tools;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

class KeyEventMapGenerator {
    private final Field[] fields = KeyEvent.class.getDeclaredFields();
    private final Map<Integer, String> descriptionByKeyCode = new HashMap<Integer, String>();

    public KeyEventMapGenerator generate() {
        try {
            this.tryToGenerate();
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return this;
    }

    private void tryToGenerate() throws IllegalArgumentException, IllegalAccessException {
        for (Field field : this.fields) {
            this.tryToGenerate(field);
        }
    }

    private void tryToGenerate(Field field) throws IllegalArgumentException, IllegalAccessException {
        if (Modifier.isStatic(field.getModifiers())) {
            String string = field.getName();
            int n = field.getInt(string);
            this.descriptionByKeyCode.put(n, string);
        }
    }

    public Map<Integer, String> getDescriptionByKeyCode() {
        return this.descriptionByKeyCode;
    }
}

