/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.text;

import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.text.TextPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JPanel;

public class TextViewer
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(850, 650);
    private final TextPanel textPanel;
    private final JButton okButton;
    private final JPanel buttonPanel;
    private boolean applied;
    private boolean showQuitButton;
    private String quitButtonText;

    public TextViewer(String string) {
        this(string, new Point(0, 0), null, null, DIALOG_DIMENSION);
    }

    public TextViewer(String string, Point point) {
        this(string, point, null, null, DIALOG_DIMENSION);
    }

    public TextViewer(String string, Point point, Dimension dimension) {
        this(string, point, null, null, dimension);
    }

    public TextViewer(String string, Point point, Colorizer colorizer, Image image) {
        this(string, point, colorizer, image, DIALOG_DIMENSION);
    }

    public TextViewer(String string, Point point, Colorizer colorizer, Image image, Dimension dimension) {
        super(point, image, string, dimension, colorizer);
        this.addEscapeBehaviour();
        this.textPanel = new TextPanel();
        this.initTextComponent();
        this.okButton = new JButton("OK");
        this.initOkButton();
        this.buttonPanel = new JPanel();
        this.initButtonPanel();
        this.showQuitButton = false;
        this.quitButtonText = "";
        this.applied = false;
        this.fillDialog();
        this.setKeyBindings();
    }

    public void addQuitButton(String string) {
        this.quitButtonText = string;
        this.showQuitButton = true;
        this.initButtonPanel();
    }

    protected void initTextComponent() {
        this.textPanel.setColors(this.getColorizer());
    }

    protected final void switchToEditable() {
        this.textPanel.setEditable(true);
    }

    private void initOkButton() {
        this.setColors(this.okButton);
        this.okButton.addActionListener(actionEvent -> this.okPressed());
    }

    protected void okPressed() {
        this.applied = true;
        this.closeDialog();
    }

    private void initButtonPanel() {
        this.setColors(this.buttonPanel);
        this.buttonPanel.setLayout(new BorderLayout());
        this.buttonPanel.add((Component)this.okButton, "East");
        this.buttonPanel.add(this.createLeftButtonPart(), "West");
    }

    protected final Component getOkButton() {
        return this.okButton;
    }

    protected final JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    protected Component createLeftButtonPart() {
        JPanel jPanel = new JPanel();
        this.setColors(jPanel);
        jPanel.setLayout(new BorderLayout());
        if (this.showQuitButton) {
            jPanel.add(this.createQuitButton(), "Center");
        }
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton(this.quitButtonText);
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    public final void useMonoscpacedText() {
        this.textPanel.useMonoscpacedText();
    }

    public final void setFontSize(int n) {
        this.textPanel.setFontSize(n);
    }

    public final void biggerFont(int n) {
        this.textPanel.biggerFont(n);
    }

    public final void useNoWordWrap() {
        this.textPanel.useNoWordWrap();
    }

    public final void scrollScrollbarToMaximumLater() {
        this.textPanel.scrollScrollbarToMaximumLater();
    }

    public final void scrollScrollbarToMinimumLater() {
        this.textPanel.scrollScrollbarToMinimumLater();
    }

    public final void setText(String string) {
        this.textPanel.setText(string);
    }

    @Override
    protected final void populateDialog() {
        this.add(this.textPanel.getComponent(), "Center");
        this.add(this.buttonPanel, "South");
    }

    protected final String getText() {
        return this.textPanel.getText();
    }

    public final void setOkButtonText(String string) {
        this.okButton.setText(string);
    }

    private void setKeyBindings() {
        this.setKeyBindingCtrlHome(() -> this.textPanel.scrollScrollbarToMinimumLater());
        this.setKeyBindingCtrlEnd(() -> this.textPanel.scrollScrollbarToMaximumLater());
        this.setKeyBindingPageUp(() -> this.textPanel.scrollScrollbarToPreviousSectionLater());
        this.setKeyBindingPageDown(() -> this.textPanel.scrollScrollbarToNextSectionLater());
    }

    public void setRows(int n) {
        this.textPanel.setRows(n);
    }

    public void setColumns(int n) {
        this.textPanel.setColumns(n);
    }

    public boolean isApplied() {
        return this.applied;
    }
}

