/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.text.autocompletion;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.text.autocompletion.AutoCompletionKey;
import de.duehl.swing.ui.text.autocompletion.AutoCompletionMode;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AutoCompletionTextComponentExtender {
    private static final int MINIMAL_LENGTH_FOR_AUTOCOMPLETION_START = 2;
    private static final String COMMIT_ACTION = "commit";
    private final JTextComponent textComponent;
    private final List<String> autoCompletionWords;
    private AutoCompletionMode autoCompletionMode;
    private AutoCompletionKey autoCompletionKey;
    private boolean addSpaceBehindAutoCompletion;
    private int changePosition;
    private String textContentBeforeChangePosition;
    private int indexOfWordStart;
    private int minimalLengthForAutoCompletionStart;

    public AutoCompletionTextComponentExtender(JTextComponent jTextComponent, List<String> list) {
        this.textComponent = jTextComponent;
        this.autoCompletionWords = CollectionsHelper.toLowerCase(list);
        Collections.sort(list);
        CollectionsHelper.toLowerCase(list);
        this.autoCompletionKey = AutoCompletionKey.ENTER;
        this.addSpaceBehindAutoCompletion = true;
        this.minimalLengthForAutoCompletionStart = 2;
    }

    public void changeActivationKeyToSpace() {
        this.autoCompletionKey = AutoCompletionKey.SPACE;
    }

    public void doNotInsertSpaceBehindCompletion() {
        this.addSpaceBehindAutoCompletion = false;
    }

    public void setMinimalLengthForAutoCompletionStart(int n) {
        if (n < 1 || n > 80) {
            throw new IllegalArgumentException("Der Wert muss zwischen 1 und 80 liegen!");
        }
        this.minimalLengthForAutoCompletionStart = n;
    }

    public void extendAutoCompletion() {
        this.autoCompletionMode = AutoCompletionMode.INSERT;
        this.initComponents();
    }

    private void initComponents() {
        this.textComponent.getDocument().addDocumentListener(this.createDocumentListener());
        InputMap inputMap = this.textComponent.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(this.autoCompletionKey.getKeyStrokeString()), COMMIT_ACTION);
        ActionMap actionMap = this.textComponent.getActionMap();
        actionMap.put(COMMIT_ACTION, new CommitAction());
    }

    private void insert(String string, int n) {
        Document document = this.textComponent.getDocument();
        if (document != null) {
            try {
                document.insertString(n, string, null);
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException(badLocationException.getMessage());
            }
        }
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getLength() != 1) {
                    return;
                }
                AutoCompletionTextComponentExtender.this.insertWithAutoCompletion(documentEvent.getOffset());
            }
        };
    }

    private void insertWithAutoCompletion(int n) {
        this.changePosition = n;
        this.textContentBeforeChangePosition = this.getContentBeforePosition();
        this.indexOfWordStart = this.findWordStart();
        int n2 = this.changePosition + 1 - this.indexOfWordStart;
        if (n2 >= this.minimalLengthForAutoCompletionStart) {
            this.searchForAutoCompletion();
        }
    }

    private String getContentBeforePosition() {
        try {
            return this.textComponent.getText(0, this.changePosition + 1);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Fehler beim Einf\u00fcgen in Text-Komponente mit Autovervollst\u00e4ndigung: \n\tchangePosition = " + this.changePosition + "\n\ttext           = " + this.textComponent.getText() + "\n\tFehler         = " + badLocationException.getLocalizedMessage(), badLocationException);
        }
    }

    private int findWordStart() {
        for (int i = this.changePosition; i >= 0; --i) {
            char c = this.textContentBeforeChangePosition.charAt(i);
            if (Character.isLetter(c)) continue;
            return i + 1;
        }
        return 0;
    }

    private void searchForAutoCompletion() {
        String string = this.textContentBeforeChangePosition.substring(this.indexOfWordStart);
        int n = Collections.binarySearch(this.autoCompletionWords, string = Text.toLowerCase(string));
        if (n < 0 && -n <= this.autoCompletionWords.size()) {
            String string2 = this.autoCompletionWords.get(-n - 1);
            if (string2.startsWith(string)) {
                String string3 = string2.substring(this.changePosition + 1 - this.indexOfWordStart);
                SwingUtilities.invokeLater(() -> this.completeAutoCompletion(string3));
            }
        } else {
            this.autoCompletionMode = AutoCompletionMode.INSERT;
        }
    }

    private void completeAutoCompletion(String string) {
        int n = this.changePosition + 1;
        this.insert(string, n);
        this.textComponent.setCaretPosition(n + string.length());
        this.textComponent.moveCaretPosition(n);
        this.autoCompletionMode = AutoCompletionMode.COMPLETION;
    }

    private void commitAutoCompleteAction() {
        if (this.autoCompletionMode == AutoCompletionMode.COMPLETION) {
            int n = this.textComponent.getSelectionEnd();
            if (this.addSpaceBehindAutoCompletion) {
                this.insert(" ", n);
                this.textComponent.setCaretPosition(n + 1);
            } else {
                this.textComponent.setCaretPosition(n);
            }
            this.autoCompletionMode = AutoCompletionMode.INSERT;
        }
    }

    private class CommitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CommitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AutoCompletionTextComponentExtender.this.commitAutoCompleteAction();
        }
    }
}

