/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.color;

import de.duehl.swing.ui.colors.ColorTool;
import de.duehl.vocabulary.japanese.common.color.data.ColorModificationType;
import de.duehl.vocabulary.japanese.common.color.data.TotalAndCorrectTotalCount;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanjiData;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import java.awt.Color;
import java.util.List;

public class VocableColors {
    public static final int DEFAULT_DELTA_FOR_FOREGROUND_COLOR = -110;
    public static final int DEFAULT_DELTA_FOR_BACKGROUND_COLOR = 180;
    public static final int NUMBER_OF_COLORS = 11;
    private static final int FAILURE_COLOR_INDEX = 0;
    private static final int SUCCESS_COLOR_INDEX = 10;
    private final List<Color> colors;
    private final int deltaForForegroundColor;
    private final int deltaForBackgroundColor;
    private final ColorModificationType colorModificationType;

    public VocableColors(Options options) {
        this(options.getColors(), options.getDeltaForForegroundColor(), options.getDeltaForBackgroundColor(), options.getColorModificationType());
    }

    VocableColors(List<Color> list, int n, int n2, ColorModificationType colorModificationType) {
        this.colors = list;
        this.deltaForForegroundColor = n;
        this.deltaForBackgroundColor = n2;
        this.colorModificationType = colorModificationType;
        this.checkNumberOfColors();
    }

    private void checkNumberOfColors() {
        if (this.colors.size() != 11) {
            throw new RuntimeException("Es gibt nicht wie erwartet 11 Farben, sondern " + this.colors.size() + ".");
        }
    }

    public Color determineBackgroundColor(InternalAdditionalVocableData internalAdditionalVocableData, boolean bl, TranslationDirection translationDirection) {
        if (bl) {
            TotalAndCorrectTotalCount totalAndCorrectTotalCount = VocableColors.createTotalAndCorrectCountOfLastTests(internalAdditionalVocableData, translationDirection);
            return this.determineBackgroundColor(totalAndCorrectTotalCount);
        }
        return Color.WHITE;
    }

    public Color determineForegroundColor(InternalAdditionalVocableData internalAdditionalVocableData, boolean bl, TranslationDirection translationDirection) {
        if (bl) {
            TotalAndCorrectTotalCount totalAndCorrectTotalCount = VocableColors.createTotalAndCorrectCountOfLastTests(internalAdditionalVocableData, translationDirection);
            return this.determineForegroundColor(totalAndCorrectTotalCount);
        }
        return Color.BLACK;
    }

    private static TotalAndCorrectTotalCount createTotalAndCorrectCountOfLastTests(InternalAdditionalVocableData internalAdditionalVocableData, TranslationDirection translationDirection) {
        int n;
        int n2;
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            n2 = internalAdditionalVocableData.getLastTenJapaneseToGermanTestsCount();
            n = internalAdditionalVocableData.getLastCorrectJapaneseToGermanTestsCount();
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            n2 = internalAdditionalVocableData.getLastGermanToJapaneseTestsCount();
            n = internalAdditionalVocableData.getLastCorrectGermanToJapaneseTestsCount();
        } else {
            throw new RuntimeException("Unbekannte \u00dcbersetzungsrichgtung " + translationDirection);
        }
        return new TotalAndCorrectTotalCount(n2, n);
    }

    private Color determineForegroundColor(TotalAndCorrectTotalCount totalAndCorrectTotalCount) {
        int n = totalAndCorrectTotalCount.getTotal();
        int n2 = totalAndCorrectTotalCount.getCorrect();
        return this.determineForegroundColor(n, n2);
    }

    private Color determineBackgroundColor(TotalAndCorrectTotalCount totalAndCorrectTotalCount) {
        int n = totalAndCorrectTotalCount.getTotal();
        int n2 = totalAndCorrectTotalCount.getCorrect();
        return this.determineBackgroundColor(n, n2);
    }

    public Color determineForegroundColor(int n, int n2) {
        int n3 = VocableColors.determineColorIndex(n, n2);
        return this.createForegroundColor(n3);
    }

    public Color determineBackgroundColor(int n, int n2) {
        if (n == 0) {
            return Color.WHITE;
        }
        int n3 = VocableColors.determineColorIndex(n, n2);
        return this.createBackgroundColor(n3);
    }

    static int determineColorIndex(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        if (n == n2) {
            return 10;
        }
        double d = 100.0 * (double)n2 / (double)n;
        return 1 + (int)(d / 11.0);
    }

    Color createForegroundColor(int n) {
        Color color = this.colors.get(n);
        color = this.createForegroundColor(color);
        return color;
    }

    Color createBackgroundColor(int n) {
        Color color = this.colors.get(n);
        color = this.createBackgroundColor(color);
        return color;
    }

    public Color createForegroundColor(Color color) {
        return this.modifyColor(color, this.deltaForForegroundColor);
    }

    public Color createBackgroundColor(Color color) {
        return this.modifyColor(color, this.deltaForBackgroundColor);
    }

    private Color modifyColor(Color color, int n) {
        switch (this.colorModificationType) {
            case ADDITIVE: {
                return ColorTool.changeColor(color, n);
            }
            case MULTIPLICATIVE: {
                return ColorTool.changeColorMultiplicative(color, n);
            }
        }
        throw new RuntimeException("Unbekannte Art '" + this.colorModificationType + "' wie Farben f\u00fcr die Erzeugung von Vorder- bzw. Hintergrundfarben modifiziert werden.");
    }

    public Color getSuccessColor() {
        return this.createBackgroundColor(10);
    }

    public Color getFailureColor() {
        return this.createBackgroundColor(0);
    }

    public Color determineKanjiBackgroundColor(InternalAdditionalKanjiData internalAdditionalKanjiData, boolean bl) {
        if (bl) {
            TotalAndCorrectTotalCount totalAndCorrectTotalCount = VocableColors.createTotalAndCorrectCountOfLastKanjiTests(internalAdditionalKanjiData);
            return this.determineBackgroundColor(totalAndCorrectTotalCount);
        }
        return Color.WHITE;
    }

    public Color determineKanjiForegroundColor(InternalAdditionalKanjiData internalAdditionalKanjiData, boolean bl) {
        if (bl) {
            TotalAndCorrectTotalCount totalAndCorrectTotalCount = VocableColors.createTotalAndCorrectCountOfLastKanjiTests(internalAdditionalKanjiData);
            return this.determineForegroundColor(totalAndCorrectTotalCount);
        }
        return Color.BLACK;
    }

    private static TotalAndCorrectTotalCount createTotalAndCorrectCountOfLastKanjiTests(InternalAdditionalKanjiData internalAdditionalKanjiData) {
        int n = internalAdditionalKanjiData.getLastTenTestsCount();
        int n2 = internalAdditionalKanjiData.getLastCorrectTestsCount();
        return new TotalAndCorrectTotalCount(n, n2);
    }

    public Color determineKanaBackgroundColor(InternalAdditionalKanaData internalAdditionalKanaData, boolean bl) {
        if (bl) {
            TotalAndCorrectTotalCount totalAndCorrectTotalCount = this.createTotalAndCorrectCountOfLastKanaTests(internalAdditionalKanaData);
            return this.determineBackgroundColor(totalAndCorrectTotalCount);
        }
        return Color.WHITE;
    }

    public Color determineKanaForegroundColor(InternalAdditionalKanaData internalAdditionalKanaData, boolean bl) {
        if (bl) {
            TotalAndCorrectTotalCount totalAndCorrectTotalCount = this.createTotalAndCorrectCountOfLastKanaTests(internalAdditionalKanaData);
            return this.determineForegroundColor(totalAndCorrectTotalCount);
        }
        return Color.BLACK;
    }

    private TotalAndCorrectTotalCount createTotalAndCorrectCountOfLastKanaTests(InternalAdditionalKanaData internalAdditionalKanaData) {
        int n = internalAdditionalKanaData.getLastTenTestsCount();
        int n2 = internalAdditionalKanaData.getLastCorrectTestsCount();
        return new TotalAndCorrectTotalCount(n, n2);
    }
}

