/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.website.update.vocables.parser;

import de.duehl.basics.datetime.date.DateHelper;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.text.NumberString;

public class VocableVersionParser {
    private final String vocablesVersion;
    private boolean success;
    private String failReason;
    private String dateAsString;
    private ImmutualDate date;
    private int number;

    public VocableVersionParser(String string) {
        this.vocablesVersion = string;
    }

    public void parse() {
        this.init();
        int n = this.vocablesVersion.indexOf("_");
        if (n == -1) {
            this.fail("Da die Version '" + this.vocablesVersion + "' keinen Unterstrich enth\u00e4lt, wird sie nicht ber\u00fccksichtigt.");
        } else {
            String string = this.vocablesVersion.substring(0, n);
            String string2 = this.vocablesVersion.substring(n + 1);
            if (string.length() != 8) {
                this.fail("Da der vordere Teil (" + string + ") der Version '" + this.vocablesVersion + "' nicht acht Zeichen lang ist, wird sie nicht ber\u00fccksichtigt.");
            } else if (!NumberString.isDigitSequence(string)) {
                this.fail("Da der vordere Teil (" + string + ") der Version '" + this.vocablesVersion + "' nicht nur aus Ziffern besteht, wird sie nicht ber\u00fccksichtigt.");
            } else if (!NumberString.isDigitSequence(string2)) {
                this.fail("Da der hintere Teil (" + string2 + ") der Version '" + this.vocablesVersion + "' nicht nur aus Ziffern besteht, wird sie nicht ber\u00fccksichtigt.");
            } else {
                this.success = true;
                this.dateAsString = string;
                this.number = NumberString.parseInt(string2);
                this.date = DateHelper.getDateFromYYYYMMDD(this.dateAsString);
            }
        }
    }

    private void init() {
        this.success = true;
        this.failReason = "";
        this.dateAsString = "";
        this.number = -1;
    }

    private void fail(String string) {
        this.success = false;
        this.failReason = string;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public String getDateAsString() {
        return this.dateAsString;
    }

    public ImmutualDate getDate() {
        return this.date;
    }

    public int getNumber() {
        return this.number;
    }
}

