/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.data;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.common.persistence.data.OwnListPersistanceData;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class OwnList
extends Vocabulary {
    public static final String OWN_LIST_DIRECTORY = FileHelper.concatPathes(SessionManager.VOCABLE_TRAINER_DIRECTORY, "own_vocable_lists");
    public static final String OWN_LISTS_EXTENSION = ".owl";
    private static final ImmutualDate NOT_SORTED_BY_FIRST_SEEN_DATE = new ImmutualDate("21.03.2024");
    private String name;
    private static final String LERNLISTE = "Lernliste";

    public OwnList(String string, String string2, String string3, List<Vocable> list) {
        super(OwnList.createDescriptionFromName(string), list, string2, string3);
        this.name = string;
    }

    public static String createDescriptionFromName(String string) {
        String string2 = string;
        string2 = string2.replace("_", " ");
        return string2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        super.setDescription(string);
    }

    @Override
    public ImmutualDate getFirstSeenDate() {
        return NOT_SORTED_BY_FIRST_SEEN_DATE;
    }

    @Override
    public void setFirstSeenDate(ImmutualDate immutualDate) {
        throw new RuntimeException("do not use");
    }

    public String determineFilename() {
        return OwnList.determineFilename(this.name);
    }

    public static String determineFilename(String string) {
        String string2 = Text.createJavaVariableName(string) + OWN_LISTS_EXTENSION;
        String string3 = FileHelper.concatPathes(OWN_LIST_DIRECTORY, string2);
        return string3;
    }

    public static void createOwnListDirectoryIfNotExisting() {
        FileHelper.createDirectoryIfNotExists(OWN_LIST_DIRECTORY);
    }

    public static String createJavaFormOfNameFromFilename(String string) {
        String string2 = FileHelper.getBareName(string);
        if (string2.endsWith(OWN_LISTS_EXTENSION)) {
            return Text.removeTextAtEndIfEndsWith(string2, OWN_LISTS_EXTENSION);
        }
        return "";
    }

    public static boolean belongsFilenameToName(String string, String string2) {
        String string3 = FileHelper.getBareName(string);
        if (string3.endsWith(OWN_LISTS_EXTENSION)) {
            String string4 = Text.removeTextAtEndIfEndsWith(string3, OWN_LISTS_EXTENSION);
            String string5 = Text.createJavaVariableName(string2);
            return string4.equals(string5);
        }
        return false;
    }

    public static FileFilter createFileFilter() {
        return GuiTools.createExtensionFileFilter(OWN_LISTS_EXTENSION);
    }

    public OwnListPersistanceData toOwnListPersistanceData() {
        OwnListPersistanceData ownListPersistanceData = new OwnListPersistanceData();
        ownListPersistanceData.setCategory(this.getCategory());
        ownListPersistanceData.setSubCategory(this.getSubCategory());
        ownListPersistanceData.setName(this.name);
        return ownListPersistanceData;
    }

    public boolean isLernliste() {
        return this.name.contains(LERNLISTE) || this.getSubCategory().contains(LERNLISTE) || this.getCategory().contains(LERNLISTE);
    }

    @Override
    public String toString() {
        return "OwnList [category=" + this.getCategory() + ", subCategory=" + this.getSubCategory() + ", name=" + this.name + "]";
    }
}

