/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components;

import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.buttons.painted.GoButton;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.tools.SelectionsHelper;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.components.data.VocableTestReactor;
import de.duehl.vocabulary.japanese.ui.components.display.KanjiAndKanaDisplay;
import de.duehl.vocabulary.japanese.ui.components.display.RomajiAndPronunciationDisplay;
import de.duehl.vocabulary.japanese.ui.components.display.TranslationCommentAndVocabularyDescriptionDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class VocableTester {
    private final VocableTestReactor vocableTestReactor;
    private final Options options;
    private final JPanel panel;
    private final JTextPane kanjiAndKanaPane;
    private final JTextPane romajiAndPronunciationPane;
    private final JTextPane commentAndVocabularyDescriptionPane;
    private final StringSelection germanToJapaneseSelection;
    private final StringSelection translationSelection;
    private final GoButton playMp3Button;
    private final JButton okButton;
    private final Random random;
    private Vocable vocable;
    private String germanTerm;
    private boolean translated;
    private boolean lastVocable;
    private Color backgroundColor;

    public VocableTester(VocableTestReactor vocableTestReactor, Options options) {
        this.vocableTestReactor = vocableTestReactor;
        this.options = options;
        this.panel = new JPanel();
        this.kanjiAndKanaPane = new JTextPane();
        this.romajiAndPronunciationPane = new JTextPane();
        this.commentAndVocabularyDescriptionPane = new JTextPane();
        this.germanToJapaneseSelection = new StringSelection("Deutscher Begriff");
        this.translationSelection = new StringSelection("\u00dcbersetzung");
        this.playMp3Button = new GoButton();
        this.okButton = new JButton("\u00dcbersetzung abschicken");
        this.random = new Random();
        this.initSelections();
        this.createPanel();
    }

    private void initSelections() {
        SelectionsHelper.initSelectionAsEditor(this.translationSelection);
        this.playMp3Button.addActionListener(actionEvent -> this.playMp3());
        this.playMp3Button.setForceSquare(true);
        this.playMp3Button.setPreferredSize(new Dimension(50, 50));
        SelectionsHelper.initSelectionAsEditor(this.germanToJapaneseSelection);
        this.germanToJapaneseSelection.biggerText(5);
        this.translationSelection.addReturnListener(() -> this.userEnteredTranslation());
        this.okButton.addActionListener(actionEvent -> this.okButtonPressed());
        this.requestFocusInTranslationField();
    }

    private void requestFocusInTranslationField() {
        SwingUtilities.invokeLater(() -> this.translationSelection.requestFocus());
    }

    private void createPanel() {
        this.panel.setLayout(new VerticalLayout(0, 3));
        TranslationDirection translationDirection = this.options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            this.panel.add(this.createKanjiKanaAndMp3PlayButtonArea());
            this.panel.add(this.romajiAndPronunciationPane);
            this.panel.add(this.commentAndVocabularyDescriptionPane);
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            this.panel.add(this.germanToJapaneseSelection.getPanel());
        } else {
            throw new RuntimeException("Unbekannte Abfragerichtung " + translationDirection);
        }
        this.panel.add(this.translationSelection.getPanel());
        this.panel.add(this.okButton);
    }

    private Component createKanjiKanaAndMp3PlayButtonArea() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.kanjiAndKanaPane, "Center");
        jPanel.add((Component)this.playMp3Button, "East");
        return jPanel;
    }

    public Component getPanel() {
        return this.panel;
    }

    public void showVocable(Vocable vocable, InternalAdditionalVocableData internalAdditionalVocableData, boolean bl) {
        this.vocable = vocable;
        this.lastVocable = bl;
        VocableColors vocableColors = new VocableColors(this.options);
        this.backgroundColor = vocableColors.determineBackgroundColor(internalAdditionalVocableData, this.options.isColorVocableDependingOnLastSuccessWhenTestingVocable(), this.options.getTranslationDirection());
        TranslationDirection translationDirection = this.options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            this.showJapaneseToGermanVocable();
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            this.showGermanToJapaneseVocable();
        } else {
            throw new RuntimeException("Unbekannte Abfragerichtung " + translationDirection);
        }
        this.translationSelection.setEditable(true);
        this.translationSelection.setText("");
        this.okButton.setText("\u00dcbersetzung abschicken");
        this.translated = false;
        this.panel.repaint();
        if (this.options.isPlayMP3WhenTestingVocables() && translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            this.playMp3();
        }
    }

    private void showJapaneseToGermanVocable() {
        this.displayKanjiAndKana();
        this.displayRomajiAndPronunciation();
        this.displayTranslationCommentAndVocabularyDescription();
        this.modifyMp3Button();
    }

    private void displayKanjiAndKana() {
        KanjiAndKanaDisplay kanjiAndKanaDisplay = new KanjiAndKanaDisplay(this.vocable, this.kanjiAndKanaPane, this.backgroundColor, this.options);
        if (!this.options.isShowKanaWhenTestingVocable()) {
            kanjiAndKanaDisplay.hideKana();
        }
        if (this.options.isShowKanaInKanjiSizeWhenTestingVocable()) {
            kanjiAndKanaDisplay.showKanaInKanjiSize();
        }
        if (this.options.isShowKanjiWhenTestingVocable()) {
            if (this.options.isHideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana() && Hiragana.containsOnlyHiragana(this.vocable.getKana())) {
                kanjiAndKanaDisplay.hideKanji();
            }
        } else {
            kanjiAndKanaDisplay.hideKanji();
        }
        kanjiAndKanaDisplay.display();
    }

    private void displayRomajiAndPronunciation() {
        RomajiAndPronunciationDisplay romajiAndPronunciationDisplay = new RomajiAndPronunciationDisplay(this.vocable, this.romajiAndPronunciationPane, this.backgroundColor, this.options);
        if (this.options.isShowRomajiWhenTestingVocable()) {
            if (this.options.isHideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana() && Hiragana.containsOnlyHiragana(this.vocable.getKana())) {
                romajiAndPronunciationDisplay.hideRomaji();
            }
        } else {
            romajiAndPronunciationDisplay.hideRomaji();
        }
        if (this.options.isShowPronunciationWhenTestingVocable()) {
            if (this.options.isHidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana() && Hiragana.containsOnlyHiragana(this.vocable.getKana())) {
                romajiAndPronunciationDisplay.hidePronunciation();
            }
        } else {
            romajiAndPronunciationDisplay.hidePronunciation();
        }
        romajiAndPronunciationDisplay.display();
    }

    private void displayTranslationCommentAndVocabularyDescription() {
        TranslationCommentAndVocabularyDescriptionDisplay translationCommentAndVocabularyDescriptionDisplay = new TranslationCommentAndVocabularyDescriptionDisplay(this.vocable, this.commentAndVocabularyDescriptionPane, this.backgroundColor, this.options);
        translationCommentAndVocabularyDescriptionDisplay.hideTranslations();
        if (!this.options.isShowCommentWhenTestingVocable()) {
            translationCommentAndVocabularyDescriptionDisplay.hideComment();
        }
        if (!this.options.isShowVocabularyDescriptionWhenTestingVocable()) {
            translationCommentAndVocabularyDescriptionDisplay.hideVocabularyDescription();
        }
        translationCommentAndVocabularyDescriptionDisplay.display();
    }

    private void modifyMp3Button() {
        this.playMp3Button.setBackgroundColor(this.backgroundColor);
        String string = this.vocable.getMp3();
        this.playMp3Button.setEnabled(!string.isBlank() && FileHelper.isFile(string));
    }

    private void showGermanToJapaneseVocable() {
        this.germanTerm = this.createGermanTerm(this.vocable);
        this.germanToJapaneseSelection.setText(this.germanTerm);
        this.germanToJapaneseSelection.setBackgroundColor(this.backgroundColor);
        this.playMp3Button.setEnabled(false);
    }

    private String createGermanTerm(Vocable vocable) {
        List<String> list = vocable.getTranslations();
        if (list.isEmpty()) {
            throw new RuntimeException("Die Vokabel hat keine deutschen \u00dcbersetzungen!\n" + vocable.toNiceString(4));
        }
        if (this.options.isUseOnlyFirstGermanTermWhenTestingVocableGermanToJapanese()) {
            return list.get(0);
        }
        int n = this.random.nextInt(list.size());
        return list.get(n);
    }

    private void okButtonPressed() {
        this.userEnteredTranslation();
        this.requestFocusInTranslationField();
    }

    private void userEnteredTranslation() {
        if (!this.translated) {
            this.handleUserEnteredTranslation();
        }
    }

    private void handleUserEnteredTranslation() {
        String string = this.translationSelection.getTrimmedText();
        if (!string.isBlank() || this.vocableTestReactor.doWeHaveToReactOnEmptyTranslation()) {
            this.translated = true;
            this.translationSelection.setEditable(false);
            if (this.lastVocable) {
                this.okButton.setText("Ende");
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setText("weiter zur n\u00e4chsten Vokabel");
            }
            this.userEnteredTranslation(string);
        }
    }

    private void userEnteredTranslation(String string) {
        TranslationDirection translationDirection = this.options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            this.userEnteredJapaneseToGermanTranslation(string);
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            this.userEnteredGermanToJapaneseTranslation(string);
        } else {
            throw new RuntimeException("Unbekannte Abfragerichtung " + translationDirection);
        }
    }

    private void userEnteredJapaneseToGermanTranslation(String string) {
        String string2 = this.vocable.getKana();
        String string3 = this.determineKanjiToTest();
        this.vocableTestReactor.userEnteredJapaneseToGermanTranslation(string2, string3, string);
    }

    private String determineKanjiToTest() {
        if (this.options.isShowKanjiWhenTestingVocable()) {
            String string = this.vocable.getKana();
            if (this.options.isHideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana() && Hiragana.containsOnlyHiragana(string)) {
                return "";
            }
            return this.vocable.getKanji();
        }
        return "";
    }

    private void userEnteredGermanToJapaneseTranslation(String string) {
        this.vocableTestReactor.userEnteredGermanToJapaneseTranslation(this.germanTerm, string);
    }

    public void playMp3() {
        String string = this.vocable.getMp3();
        VocabularyTools.playMp3(string);
        this.requestFocusInTranslationField();
    }

    public void disable() {
        this.translationSelection.setEnabled(false);
        this.okButton.setEnabled(false);
    }
}

