/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.data.VocablesWithSpecificConstraintFinder;
import de.duehl.vocabulary.japanese.ui.data.VocablesWithSpecificConstraintLister;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AllVocablesWithSpecificConstraintDialog
extends NonModalFrameDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1500, 1000);
    private final String constraintDescription;
    private final List<String> constraints;
    private final VocablesWithSpecificConstraintFinder finder;
    private final String descritpionForLister;
    private final VocablesWithSpecificConstraintLister lister;
    private final JPanel panel;
    private final JScrollPane scrollPane;

    public AllVocablesWithSpecificConstraintDialog(Image image, Point point, String string, String string2, List<String> list, VocablesWithSpecificConstraintFinder vocablesWithSpecificConstraintFinder, String string3, VocablesWithSpecificConstraintLister vocablesWithSpecificConstraintLister) {
        super(point, image, string, DIALOG_DIMENSION);
        this.addEscapeBehaviour();
        this.constraintDescription = string2;
        this.constraints = list;
        this.finder = vocablesWithSpecificConstraintFinder;
        this.descritpionForLister = string3;
        this.lister = vocablesWithSpecificConstraintLister;
        this.panel = new JPanel();
        this.scrollPane = GuiTools.createScrollPane(this.panel);
        this.fillDialog();
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        GuiTools.scrollScrollbarToMinimumLater(this.scrollPane);
    }

    private void initElements() {
        this.initPanel();
        this.fillPanel();
    }

    private void initPanel() {
        this.panel.setLayout(new GridLayout(0, 3, 5, 5));
    }

    private void fillPanel() {
        for (String string : this.constraints) {
            JButton jButton = this.createButton(string);
            this.panel.add(jButton);
        }
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(string);
        GuiTools.biggerFont(jButton, 5);
        jButton.addActionListener(actionEvent -> this.listVocablesWithConstraint(string));
        return jButton;
    }

    private void listVocablesWithConstraint(String string) {
        List<Vocable> list = this.finder.findVocablesWithSpecificConstraint(string);
        this.lister.listVocablesWithSpecificConstraint(this.descritpionForLister + " " + string, list);
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.scrollPane, "Center");
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }
}

