/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.grammar;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.MultipleElementsPanel;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.tools.SelectionsHelper;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.data.HistoricalOwnListPersistanceDataList;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.grammar.AdjectiveSearchWords;
import de.duehl.vocabulary.japanese.grammar.VerbSearchWords;
import de.duehl.vocabulary.japanese.grammar.table.data.GrammarTableType;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.options.GrammarTableOptionsPanel;
import de.duehl.vocabulary.japanese.ui.listcommander.selector.OwnListSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GrammarTableCreatorDialog
extends ModalDialogBase {
    public static final int VERTICAL_SPACE_BETWEEN_PARTS = 5;
    public static final int VERTICAL_SPACE_IN_PARTS = 3;
    private final FumikoDataStructures dataStructures;
    private final StringSelection titleSelection;
    private final OwnListSelector ownListSelector;
    private final List<JCheckBox> verbFormCheckBoxes;
    private final List<JCheckBox> iAdjectiveFormCheckBoxes;
    private final List<JCheckBox> naAdjectiveFormCheckBoxes;
    private final JTabbedPane verbOrAdjectiveFormsTabs;
    private final JPanel verbFormsTabPanel;
    private final JPanel iAdjectiveFormsTabPanel;
    private final JPanel naAdjectiveFormsTabPanel;
    private final GrammarTableOptionsPanel grammarOptionsPanel;
    private String tableTitle;
    private OwnList ownList;
    private GrammarTableType grammarTableType;
    private List<String> searchWords;
    private boolean applied;

    public GrammarTableCreatorDialog(FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        super(fumikoUiObjects.getGuiLocation(), fumikoUiObjects.getProgramImage(), "Erzeugung grammatikalischer Tabllen von Verben oder Adjektiven");
        this.dataStructures = fumikoDataStructures;
        this.titleSelection = new StringSelection("Der Titel der Tabelle");
        Options options = fumikoDataStructures.getOptions();
        this.ownListSelector = new OwnListSelector(fumikoDataStructures, fumikoUiObjects, options.getHistoricalOwnLists(), ownList -> this.selectedOwnListChanged(ownList), () -> this.getLocation());
        this.ownListSelector.allowSelectAll();
        this.ownListSelector.createSelector();
        this.verbFormCheckBoxes = new ArrayList<JCheckBox>();
        this.iAdjectiveFormCheckBoxes = new ArrayList<JCheckBox>();
        this.naAdjectiveFormCheckBoxes = new ArrayList<JCheckBox>();
        this.verbOrAdjectiveFormsTabs = new JTabbedPane();
        this.verbFormsTabPanel = new JPanel();
        this.iAdjectiveFormsTabPanel = new JPanel();
        this.naAdjectiveFormsTabPanel = new JPanel();
        this.grammarOptionsPanel = new GrammarTableOptionsPanel(options, () -> this.getLocation(), fumikoUiObjects);
        this.init();
        this.fillDialog();
    }

    private void selectedOwnListChanged(OwnList ownList) {
        if (!this.ownListSelector.isOwnListIsConstructedWithAllSelection()) {
            Options options = this.dataStructures.getOptions();
            HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList = options.getHistoricalOwnLists();
            historicalOwnListPersistanceDataList.addOwnListData(ownList.toOwnListPersistanceData());
        }
        this.ownList = ownList;
    }

    private void init() {
        this.initTitleSelection();
        this.initVerbFormCheckBoxes();
        this.initIAdjectiveFormCheckBoxes();
        this.initNaAdjectiveFormCheckBoxes();
        this.initMainTabs();
        this.initTabPanels();
        this.initValues();
    }

    private void initTitleSelection() {
        SelectionsHelper.initSelectionAsEditor(this.titleSelection);
    }

    private void initVerbFormCheckBoxes() {
        this.initFormCheckBoxes(VerbSearchWords.SORTED_VERB_SEARCH_WORDS, this.verbFormCheckBoxes);
    }

    private void initIAdjectiveFormCheckBoxes() {
        this.initFormCheckBoxes(AdjectiveSearchWords.SORTED_I_ADJEKTIVE_SEARCH_WORDS, this.iAdjectiveFormCheckBoxes);
    }

    private void initNaAdjectiveFormCheckBoxes() {
        this.initFormCheckBoxes(AdjectiveSearchWords.SORTED_NA_ADJEKTIVE_SEARCH_WORDS, this.naAdjectiveFormCheckBoxes);
    }

    private void initFormCheckBoxes(List<String> list, List<JCheckBox> list2) {
        for (String string : list) {
            JCheckBox jCheckBox = new JCheckBox(string);
            list2.add(jCheckBox);
        }
    }

    private void initMainTabs() {
        this.verbOrAdjectiveFormsTabs.add("Verbformen", GuiTools.createScrollPane(this.verbFormsTabPanel));
        this.verbOrAdjectiveFormsTabs.add("I-Adjektivformen", GuiTools.createScrollPane(this.iAdjectiveFormsTabPanel));
        this.verbOrAdjectiveFormsTabs.add("NA-Adjektivformen", GuiTools.createScrollPane(this.naAdjectiveFormsTabPanel));
    }

    private void initTabPanels() {
        this.initTabPane(this.verbFormsTabPanel, this.verbFormCheckBoxes);
        this.initTabPane(this.iAdjectiveFormsTabPanel, this.iAdjectiveFormCheckBoxes);
        this.initTabPane(this.naAdjectiveFormsTabPanel, this.naAdjectiveFormCheckBoxes);
    }

    private void initTabPane(JPanel jPanel, List<JCheckBox> list) {
        MultipleElementsPanel<JCheckBox> multipleElementsPanel = new MultipleElementsPanel<JCheckBox>(list, 3, 5);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(multipleElementsPanel, "Center");
    }

    private void initValues() {
        this.tableTitle = "";
        this.grammarTableType = GrammarTableType.VERB;
        this.applied = false;
    }

    @Override
    protected void populateDialog() {
        this.add(this.createMainPart(), "Center");
        this.add(this.createButtonPart(), "South");
        this.pack();
    }

    private Component createMainPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(5, 3));
        jPanel.add(this.createTitleSelection());
        jPanel.add(this.createOwnListSelection());
        jPanel.add(this.grammarOptionsPanel.getPanel());
        jPanel.add(this.createSearchWordSelection());
        return jPanel;
    }

    private Component createTitleSelection() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Der Titel der erzeugten Tabelle", jPanel);
        jPanel.add(this.titleSelection.getPanel());
        return jPanel;
    }

    private Component createOwnListSelection() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Die eigene Liste, aus der die Verben bzw. Adjektive entnommen werden", jPanel);
        jPanel.add(this.ownListSelector.getPanel());
        return jPanel;
    }

    private Component createSearchWordSelection() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle("Suchworte - die grammatikalischen Formen, die in die Tabelle sollen (nur die vom sichtbaren Reiter werden verwendet)", jPanel);
        jPanel.add(this.verbOrAdjectiveFormsTabs);
        jPanel.add(GuiTools.centerHorizontal(this.createSelectionsButtonsPart()));
        return jPanel;
    }

    private Component createSelectionsButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 1, 1));
        jPanel.add(this.createSelectAllButton());
        jPanel.add(this.createDeselectAllButton());
        return jPanel;
    }

    private Component createSelectAllButton() {
        JButton jButton = new JButton("Alle ausw\u00e4hlen");
        jButton.addActionListener(actionEvent -> this.selectAll(true));
        return jButton;
    }

    private Component createDeselectAllButton() {
        JButton jButton = new JButton("Alle entfernen");
        jButton.addActionListener(actionEvent -> this.selectAll(false));
        return jButton;
    }

    private void selectAll(boolean bl) {
        List<JCheckBox> list = this.determineActiveFormCheckBoxes();
        for (JCheckBox jCheckBox : list) {
            jCheckBox.setSelected(bl);
        }
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private Component createOkButton() {
        JButton jButton = new JButton("Tabelle erzeugen");
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        this.applied = true;
        if (this.applied) {
            this.checkOwnListIstValid();
        }
        if (this.applied) {
            this.determineTableTitle();
        }
        if (this.applied) {
            this.determineVerbOrAdjectivAndSearchWords();
        }
        if (this.applied) {
            this.grammarOptionsPanel.storeIntoOptions();
        }
        if (this.applied) {
            this.closeDialog();
        }
    }

    private void checkOwnListIstValid() {
        if (this.ownList == null || this.ownList.equals(OwnLists.NO_OWN_LIST_FOUND)) {
            GuiTools.informUser(this.getWindowAsComponent(), "Die Tabellenerstellung kann nicht gestartet werden", "Es wurde keine eigene Liste ausgew\u00e4hlt.");
            this.applied = false;
        }
    }

    private void determineTableTitle() {
        this.tableTitle = this.titleSelection.getTrimmedText();
        if (this.tableTitle.isBlank()) {
            GuiTools.informUser(this.getWindowAsComponent(), "Die Tabellenerstellung kann nicht gestartet werden", "Es wurde kein Titel eingegeben.");
            this.applied = false;
        }
    }

    private void determineVerbOrAdjectivAndSearchWords() {
        List<JCheckBox> list = this.determineActiveFormCheckBoxes();
        this.searchWords = new ArrayList<String>();
        for (JCheckBox jCheckBox : list) {
            if (!jCheckBox.isSelected()) continue;
            String string = jCheckBox.getText();
            this.searchWords.add(string);
        }
        if (this.searchWords.isEmpty()) {
            GuiTools.informUser(this.getWindowAsComponent(), "Die Tabellenerstellung kann nicht gestartet werden", "Es wurden keine grammatikalischen Formen ausgew\u00e4hlt.");
            this.applied = false;
        }
    }

    private List<JCheckBox> determineActiveFormCheckBoxes() {
        List<JCheckBox> list;
        int n = this.verbOrAdjectiveFormsTabs.getSelectedIndex();
        if (n == 0) {
            this.grammarTableType = GrammarTableType.VERB;
            list = this.verbFormCheckBoxes;
        } else if (n == 1) {
            this.grammarTableType = GrammarTableType.I_ADJEKTIV;
            list = this.iAdjectiveFormCheckBoxes;
        } else if (n == 2) {
            this.grammarTableType = GrammarTableType.NA_ADJEKTIV;
            list = this.naAdjectiveFormCheckBoxes;
        } else {
            GuiTools.informUser(this.getWindowAsComponent(), "Die Tabellenerstellung kann nicht gestartet werden", "Es wurde nicht erkannt, ob der Reiter mit den Verb- oder der Reiter mit den Adjektivformen aktiv ist.\n\nUnbekannter Tab Index " + n);
            this.applied = false;
            list = new ArrayList<JCheckBox>();
        }
        return list;
    }

    public String getTableTitle() {
        return this.tableTitle;
    }

    public OwnList getOwnList() {
        return this.ownList;
    }

    public GrammarTableType getGrammarTableType() {
        return this.grammarTableType;
    }

    public List<String> getSearchWords() {
        return this.searchWords;
    }

    public boolean isApplied() {
        return this.applied;
    }
}

