/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.zipwithzip4j.zip;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.zip.data.ZipArchive;
import java.io.File;
import java.io.IOException;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.EncryptionMethod;

public class ZipWithZip4J {
    private final ZipArchive zipArchive;
    private boolean cypher;
    private String password;
    private ZipParameters zipParameters;

    public ZipWithZip4J(ZipArchive zipArchive) {
        this.zipArchive = zipArchive;
    }

    public void cypher(String string) {
        this.cypher = true;
        this.password = string;
    }

    public void zip() {
        if (this.cypher) {
            this.zipWithPassword();
        } else {
            this.zipWithoutPassword();
        }
    }

    private void zipWithPassword() {
        String string = this.zipArchive.getArchiveFilename();
        this.zipParameters = new ZipParameters();
        this.zipParameters.setEncryptFiles(true);
        this.zipParameters.setEncryptionMethod(EncryptionMethod.AES);
        this.zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
        try (ZipFile zipFile = new ZipFile(string, this.password.toCharArray());){
            this.addToZip(zipFile);
        }
        catch (ZipException zipException) {
            throw new RuntimeException(zipException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void zipWithoutPassword() {
        this.zipParameters = new ZipParameters();
        this.zipParameters.setEncryptFiles(false);
        String string = this.zipArchive.getArchiveFilename();
        try (ZipFile zipFile = new ZipFile(string);){
            this.addToZip(zipFile);
        }
        catch (ZipException zipException) {
            throw new RuntimeException(zipException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void addToZip(ZipFile zipFile) throws ZipException {
        for (String string : this.zipArchive.getFilesToZip()) {
            if (FileHelper.isDirectory(string)) {
                zipFile.addFolder(new File(string), this.zipParameters);
                continue;
            }
            if (FileHelper.isFile(string)) {
                zipFile.addFile(new File(string), this.zipParameters);
                continue;
            }
            throw new RuntimeException("Der Eintrag in die Liste der zu verpackenden Dateien und Verzeichnisse ist weder als Datei noch als Verzeichnis vorhanden.\n\ttoZip = " + string + "\n");
        }
    }
}

