package de.duehl.basics.currency;

import de.duehl.basics.text.NumberString;

/*
 * Copyright 2026 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt Methoden rund um die Währung Euro zur Verfügung.
 *
 * @version 1.01     2026-01-28
 * @author Christian Dühl
 */

public class EuroTools {

    private static final double EURO_TO_DM = 1.95583D;

    /**
     * Rechnet einen DM-Betrag in Euro um.
     *
     * @param amountInDm
     *            Der Betrag in DM in der Form "1.000,00".
     * @return Der umgerechnete Betrag in Euro.
     */
    public static String dmToEuro(String amountInDm) {
        double failureValue = Double.MIN_VALUE;
        double dm = NumberString.parseDoubleWithTaupuAndKomma(amountInDm, failureValue);
        if (dm == failureValue) {
            throw new RuntimeException("Der DM-Betrag '" + amountInDm + "' lässt sich nicht in "
                    + "eine Zahl überführen.");
        }
        double euro = dmToEuro(dm);
        return NumberString.twoDecimalPlacesTaupu(euro);
    }

    /**
     * Rechnet einen DM-Betrag in Euro um.
     *
     * @param dm
     *            Der Betrag in DM.
     * @return Der umgerechnete Betrag in Euro.
     */
    public static double dmToEuro(double dm) {
        return dm / EURO_TO_DM;
    }

    /**
     * Rechnet einen DM-Betrag in Euro um.
     *
     * @param dm
     *            Der Betrag in DM.
     * @return Der umgerechnete Betrag in Euro.
     */
    public static double euroToDm(double euro) {
        return euro * EURO_TO_DM;
    }

}
