package de.duehl.basics.io.textfile;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileFromJarReader;
import de.duehl.basics.io.Reader;

/**
 * Diese Klasse liest eine Text-Datei aus einer Jar ein.
 *
 * @version 1.01     2019-05-14
 * @author Christian Dühl
 */

public class FullTextFileFromJarReader extends FullTextFileReader {

    /** Klasse neben der die Datei sich im befindet. */
    private final Class<?> clazz;

    /**
     * Konstruktor.
     *
     * @param filename
     *            Name der einzulesenden Datei ohne Pfad.
     * @param charset
     *            Kodierung der einzulesenden Datei.
     * @param clazz
     *            Klasse neben der die Datei sich im befindet.
     */
    public FullTextFileFromJarReader(String filename, Charset charset, Class<?> clazz) {
        super(filename, charset);
        this.clazz = clazz;
    }

    /** Öffnet den Reader zum Einlesen der Datei. */
    @Override
    protected Reader openReader() {
        return new FileFromJarReader(clazz, filename, charset);
    }

}
