package de.duehl.basics.logic;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt das Ergebnis einer Prüfung dar mit Wahrheitswert und einem im Falle des
 * Fehlschlags gefülltem Fehlertext.
 *
 * @version 1.01     2017-03-13
 * @author Christian Dühl
 */

public class CheckResult {

    /** Gibt an, ob die Prüfung fehlgeschlagen ist. */
    private boolean checkFailed;

    /** Beschreibung des aufgetretenen Fehlers, ist gefüllt, wenn die Prüfung fehlgeschlagen ist. */
    private String errorText;

    /** Konstruktor. */
    public CheckResult() {
        checkFailed = false;
        errorText = "";
    }

    /**
     * Die Prüfung schlägt fehl.
     *
     * @param errorText
     *            Beschreibung des aufgetretenen Problems.
     */
    public void failed(String errorText) {
        if (errorText.isEmpty()) {
            throw new IllegalArgumentException(
                    "Diese Methode darf nicht mit leerem Fehlertext aufgerufen werden!");
        }
        checkFailed = true;
        this.errorText = errorText;
    }

    /** Gibt an, ob die Prüfung fehlerlos war. */
    public boolean isOk() {
        return !hasFailed();
    }

    /** Gibt an, ob die Prüfung Fehler gefunden hat. */
    public boolean hasFailed() {
        return checkFailed;
    }

    /**
     * Getter für die Beschreibung des aufgetretenen Problems. Darf nur aufgerufen werden, wenn
     * auch ein Problem vorliegt!
     *
     * @throws RuntimeException
     *             Falls die Methode aufgerufen wird, aber kein Fehler vorliegt.
     */
    public String getErrorText() {
        if (isOk()) {
            throw new RuntimeException(
                    "Diese Methode darf nicht aufgerufen werden, wenn der Check erfolgreich war!");
        }
        return errorText;
    }

    /** Stringrepräsentation. */
    @Override
    public String toString() {
        return "CheckResult [checkFailed=" + checkFailed + ", errorText=" + errorText + "]";
    }

}
