package de.duehl.basics.autodetect;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

import de.duehl.basics.autodetect.ent.multiple.MultipleEntityReplacer;
import de.duehl.basics.autodetect.ent.multiple.MultipleEntityReplacerWithThingsFinder;
import de.duehl.basics.collections.CollectionsHelper;

public class DetectViaListTest {

    @Test
    public void createEntityString() {
        String ent = "Am Apfelbaum wäscht ein Apfel. "
                + "Auf dem Boden liegen Birnen und eine matschige Birne dazu.";
        List<String> list = CollectionsHelper.buildListFrom("Apfel", "Birne");
        String replacementFrontPart = "obst";

        MultipleEntityReplacer detect = new MultipleEntityReplacerWithThingsFinder(ent, replacementFrontPart,
                e -> AutoDetectionHelper.findAllSearchWords(e, list));
        detect.replace();

        List<String> obst = detect.getList();
        assertEquals(2, obst.size());
        assertEquals("Apfel", obst.get(0));
        assertEquals("Birne", obst.get(1));

        String actualEnt = detect.getEnt();
        String expectedEnt = "Am Apfelbaum wäscht ein <<obst:1>>. "
                + "Auf dem Boden liegen Birnen und eine matschige <<obst:2>> dazu.";
        assertEquals(expectedEnt, actualEnt);

        String actualAutoComment = detect.getAutoComment();
        String expectedAutoComment = "[obst detected] [obst detected]";
        assertEquals(expectedAutoComment, actualAutoComment);
    }

}
