package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.datetime.date.ImmutualDate;

public class DateParseMethodMonthWordsBlanksTest {

    @Test
    public void parseShortMonthWithDotSingleDigitDay() {
        DateParseMethod method = new DateParseMethodMonthWordsBlanks("1. Feb. 2012");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(1, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2012, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseShortMonthWithoutDotSingleDigitDay() {
        DateParseMethod method = new DateParseMethodMonthWordsBlanks("1. Feb 2012");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(1, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2012, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseShortMonthWithDotTwoDigitDay() {
        DateParseMethod method = new DateParseMethodMonthWordsBlanks("01. Feb. 2012");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(1, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2012, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseShortMonthWithoutDotTwoDigitDay() {
        DateParseMethod method = new DateParseMethodMonthWordsBlanks("01. Feb 2012");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(1, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2012, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseLongMonthWithDotSingleDigitDay() {
        DateParseMethod method = new DateParseMethodMonthWordsBlanks("1. Februar. 2012");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(1, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2012, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseLongMonthWithouDotSingleDigitDay() {
        DateParseMethod method = new DateParseMethodMonthWordsBlanks("1. Februar 2012");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(1, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2012, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseLongMonthWithDotTwoDigitDay() {
        DateParseMethod method = new DateParseMethodMonthWordsBlanks("01. Februar. 2012");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(1, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2012, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseLongMonthWithoutDotTwoDigitDay() {
        DateParseMethod method = new DateParseMethodMonthWordsBlanks("01. Februar 2012");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(1, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2012, date.getYear());

        assertTrue(date.isValid());
    }

}
