package de.duehl.basics.io.textfile.dictionary.io;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.junit.Test;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.textfile.dictionary.Dictionary;
import de.duehl.basics.io.textfile.dictionary.DictionaryEntry;
import de.duehl.basics.io.textfile.dictionary.io.reader.DictionaryFromTextFileInJarReader;
import de.duehl.basics.io.textfile.dictionary.io.reader.DictionaryFromTextFileReader;

public class DictionayrFromTextFileInJarReaderTest {

    @Test
    public void read() {
        Class<?> clazz = this.getClass();
        DictionaryFromTextFileReader reader = new DictionaryFromTextFileInJarReader(
                "DictionaryTestFile.txt", Charset.UTF_8, clazz, "#");
        reader.beQuiet();
        reader.read();
        Dictionary dictionary = reader.getDictionary();

        assertEquals(3, dictionary.size());

        DictionaryEntry entry1 = dictionary.get(0);
        DictionaryEntry entry2 = dictionary.get(1);
        DictionaryEntry entry3 = dictionary.get(2);

        assertEquals(5, entry1.size());
        assertEquals(3, entry2.size());
        assertEquals(2, entry3.size());

        assertEquals("Englisches Wort", entry1.getMainWord());
        List<String> alternatives1 = entry1.getAlternatives();
        assertEquals("Deutsches Wort 1", alternatives1.get(0));
        assertEquals("Deutsches Wort 2", alternatives1.get(1));
        assertEquals("Deutsches Wort 3", alternatives1.get(2));
        assertEquals("Deutsches Wort 4", alternatives1.get(3));

        assertEquals("honey", entry2.getMainWord());
        List<String> alternatives2 = entry2.getAlternatives();
        assertEquals("Honig", alternatives2.get(0));
        assertEquals("Liebling", alternatives2.get(1));

        assertEquals("bee", entry3.getMainWord());
        List<String> alternatives3 = entry3.getAlternatives();
        assertEquals("Biene", alternatives3.get(0));
    }

    @Test
    public void read2() {
        Class<?> clazz = this.getClass();
        DictionaryFromTextFileReader reader = new DictionaryFromTextFileInJarReader(
                "DictionaryTestFile-2.txt", Charset.UTF_8, clazz, "#");
        reader.beQuiet();
        reader.read();
        Dictionary dictionary = reader.getDictionary();

        assertEquals(3, dictionary.size());

        DictionaryEntry entry1 = dictionary.get(0);
        DictionaryEntry entry2 = dictionary.get(1);
        DictionaryEntry entry3 = dictionary.get(2);

        assertEquals(5, entry1.size());
        assertEquals(3, entry2.size());
        assertEquals(2, entry3.size());

        assertEquals("Englisches Wort", entry1.getMainWord());
        List<String> alternatives1 = entry1.getAlternatives();
        assertEquals("Deutsches Wort 1", alternatives1.get(0));
        assertEquals("Deutsches Wort 2", alternatives1.get(1));
        assertEquals("Deutsches Wort 3", alternatives1.get(2));
        assertEquals("Deutsches Wort 4", alternatives1.get(3));

        assertEquals("honey", entry2.getMainWord());
        List<String> alternatives2 = entry2.getAlternatives();
        assertEquals("Honig", alternatives2.get(0));
        assertEquals("Liebling", alternatives2.get(1));

        assertEquals("bee", entry3.getMainWord());
        List<String> alternatives3 = entry3.getAlternatives();
        assertEquals("Biene", alternatives3.get(0));
    }

    @Test (expected = RuntimeException.class)
    public void read2WithError() {
        Class<?> clazz = this.getClass();
        DictionaryFromTextFileReader reader = new DictionaryFromTextFileInJarReader(
                "DictionaryTestFile-2.txt", Charset.UTF_8, clazz, "#");
        reader.beQuiet();
        reader.multipleEqualValuesAreError();
        reader.read();
    }

    @Test (expected = RuntimeException.class)
    public void read3WithError() {
        Class<?> clazz = this.getClass();
        DictionaryFromTextFileReader reader = new DictionaryFromTextFileInJarReader(
                "DictionaryTestFile-3.txt", Charset.UTF_8, clazz, "#");
        reader.beQuiet();
        reader.multipleEqualValuesAreError();
        reader.read();
    }


    @Test (expected = RuntimeException.class)
    public void read4WithError() {
        Class<?> clazz = this.getClass();
        DictionaryFromTextFileReader reader = new DictionaryFromTextFileInJarReader(
                "DictionaryTestFile-4.txt", Charset.UTF_8, clazz, "#");
        reader.beQuiet();
        reader.multipleEqualValuesAreError();
        reader.read();
    }

}
