package de.duehl.basics.logic;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.logic.BeginAndEndTester.Result;

public class BeginAndEndTesterTest {

    @Test
    public void create() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        assertNotNull(tester);
    }

    @Test
    public void testOk1() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        String input = "abc &def# ghi";
        Result result = tester.check(input);
        assertEquals(true, result.isOk());
        assertEquals("", result.getErrorMesssage());
    }

    @Test
    public void testOk2() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        String input = "abc &def# ghi &jhk# lmn";
        Result result = tester.check(input);
        assertEquals(true, result.isOk());
        assertEquals("", result.getErrorMesssage());
    }

    @Test
    public void testOk3() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        String input = "abc";
        Result result = tester.check(input);
        assertEquals(true, result.isOk());
        assertEquals("", result.getErrorMesssage());
    }

    @Test
    public void testOk4() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        String input = "";
        Result result = tester.check(input);
        assertEquals(true, result.isOk());
        assertEquals("", result.getErrorMesssage());
    }

    @Test
    public void testOk5() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        String input = "&#";
        Result result = tester.check(input);
        assertEquals(true, result.isOk());
        assertEquals("", result.getErrorMesssage());
    }

    @Test
    public void testOk6() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        String input = "&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#&#";
        Result result = tester.check(input);
        assertEquals(true, result.isOk());
        assertEquals("", result.getErrorMesssage());
    }

    @Test
    public void testFail1() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        String input = "&";
        Result result = tester.check(input);
        assertEquals(false, result.isOk());
        assertEquals("Letztes '&' an Stelle 0 ist nicht mit '#' beendet worden!",
                result.getErrorMesssage());
    }

    @Test
    public void testFail2() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        String input = "#";
        Result result = tester.check(input);
        assertEquals(false, result.isOk());
        assertEquals("Ein '#' wurde an  Stelle 0 gefunden ohne vorheriges '&'!",
                result.getErrorMesssage());
    }

    @Test
    public void testFail3() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        String input = "#&";
        Result result = tester.check(input);
        assertEquals(false, result.isOk());
        assertEquals("Ein '#' wurde an  Stelle 0 gefunden ohne vorheriges '&'!",
                result.getErrorMesssage());
    }

    @Test
    public void testFail4() {
        BeginAndEndTester tester = new BeginAndEndTester('&', '#');
        String input = "abc &de&ghi#f# jhk";
        Result result = tester.check(input);
        assertEquals(false, result.isOk());
        assertEquals("Letztes '&' an Stelle 4 ist nicht mit '#' beendet worden!",
                result.getErrorMesssage());
    }

    @Test
    public void testFail5() {
        BeginAndEndTester tester = new BeginAndEndTester('$', '%');
        String input = "abc $de$ghi%f% jhk";
        Result result = tester.check(input);
        assertEquals(false, result.isOk());
        assertEquals("Letztes '$' an Stelle 4 ist nicht mit '%' beendet worden!",
                result.getErrorMesssage());
    }

}
