package de.duehl.basics.start;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.proccess.ExternalProcess;

public class ExternalProcessTestCreateFileBatch {

    private static final String PATH = "c:/temp/";
    private static final String NAME_PRE = "externalProcessTestCreateFileBatch";

    private final String batchFile;
    private final String outputFile;

    public ExternalProcessTestCreateFileBatch () {
        batchFile = FileHelper.concatPathes(PATH, NAME_PRE + ".bat");
        outputFile = FileHelper.concatPathes(PATH, NAME_PRE + ".output");
        deleteOutputFile();
        createBatchFile();
    }

    private void deleteOutputFile() {
        FileHelper.deleteFileIfExistent(outputFile);
    }

    private void createBatchFile() {
        String batchContents = "@echo huhu > " + outputFile;
        FileHelper.writeTextToFile(batchContents, batchFile);
    }

    private void run() {
        /* Folgendes Läuft, man muss aber das sich öffnende Fenster mit exit verlassen: */
        //String[] params = { "cmd", "/c", "start", batchFile };
        //ExternalProcess externalProcess = new ExternalProcess(params);

        /* Das hier läuft einfach! Auch ohne Extra Ausgabe in ExternalProcess! */
        //String[] params = { batchFile };
        //ExternalProcess externalProcess = new ExternalProcess(params);

        ExternalProcess externalProcess = new ExternalProcess(batchFile);
        externalProcess.runWaitAndHandleErrors();
    }

    public static void main(String[] args) {
        new ExternalProcessTestCreateFileBatch().run();
    }
}
