package de.duehl.basics.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.system.starter.SasStarter;
import de.duehl.basics.system.starter.SasStarter.SasType;
import de.duehl.basics.logging.FileLogger;
import de.duehl.basics.logging.Logger;
import de.duehl.basics.logic.PrintErrorHandler;

public class SasStarterTest {

    public SasStarterTest() {
        String prg = "c:/temp/bla.sas";
        String log = "c:/temp/bla.log";
        String err = "c:/temp/bla.err";
        String sasBinary = "C:/Program Files/SAS/SASFoundation/9.2(32-bit)/sas.exe";
        String logPath = "c:/temp/";
        Logger logger = FileLogger.create("SasStarterTest", ".log", logPath);
        PrintErrorHandler error = new PrintErrorHandler();
        SasStarter starter = new SasStarter(sasBinary, logger, error);
        starter.runAndWait(SasType.NORMAL, prg, log, err);
    }

    public static void main(String[] args) {
        new SasStarterTest();
    }

}



/* c:\temp\bla.sas:


%let ftth = s:\Telekom\FTTh\zzz_ausgelieferte_bearbeitungsverzeichnisse\tranche2\20121001_Bremerhaven;

libname daten "&ftth.\daten";

%let menge_in  = eigentuemer04;

options compress=yes;

data e1;
    set daten.&menge_in.;
    if mod(_n_,1000) = 0 then put "Einlesen: " _n_ commax15.;

run;

data e2;
    set e1;
    biff _n_ eq 1;
run;


*/
