package de.duehl.basics.start;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.FileHelper;

import de.duehl.basics.io.zip.ZipFilesWith7Zip;
import de.duehl.basics.io.zip.data.ZipArchive;

public class Testing7ZipZipping {

    public static void main(String[] args) {
        String dir = "c:/temp/zipping_test2";
        String back = ""; // _2

        String datenDir = FileHelper.concatPathes(dir, "daten");

        String zipFilenameOhnePw =
                FileHelper.concatPathes(dir, "1_zip_test_ohne_Passwort" + back + ".zip");
        String zipFilenameMitPw1 =
                FileHelper.concatPathes(dir, "2_zip_test_mit_Passwort_7z" + back + ".7z");
        String zipFilenameMitPw2 =
                FileHelper.concatPathes(dir, "3_zip_test_mit_Passwort_zip" + back + ".zip");
        String zipFilenameMitPw3 =
                FileHelper.concatPathes(dir, "4_zip_test_mit_Passwort_7z_neues_7zip" + back + ".7z");

        ZipArchive archiveOhnePw = new ZipArchive(zipFilenameOhnePw, datenDir);
        ZipArchive archiveMitPw1 = new ZipArchive(zipFilenameMitPw1, datenDir);
        ZipArchive archiveMitPw2 = new ZipArchive(zipFilenameMitPw2, datenDir);
        ZipArchive archiveMitPw3 = new ZipArchive(zipFilenameMitPw3, datenDir);

        System.out.println("Zippe ohne PW");
        ZipFilesWith7Zip zipFilesOhnePw = new ZipFilesWith7Zip();
        zipFilesOhnePw.zip(archiveOhnePw);
        System.out.println("Erzeugte Dateien ohne PW: " + zipFilesOhnePw.getCreatedFilenames());

        System.out.println("Zippe mit PW 7z");
        ZipFilesWith7Zip zipFilesMitPw1 = new ZipFilesWith7Zip();
        zipFilesMitPw1.create7zFile();
        zipFilesMitPw1.cypher("Test"); // Bitte das Passwort nicht wirklich verwenden!
        zipFilesMitPw1.zip(archiveMitPw1);
        System.out.println("Erzeugte Dateien mit PW 7z: " + zipFilesMitPw1.getCreatedFilenames());

        System.out.println("Zippe mit PW zip");
        ZipFilesWith7Zip zipFilesMitPw2 = new ZipFilesWith7Zip();
        zipFilesMitPw2.cypher("Test"); // Bitte das Passwort nicht wirklich verwenden!
        zipFilesMitPw2.zip(archiveMitPw2);
        System.out.println("Erzeugte Dateien mit PW zip: " + zipFilesMitPw2.getCreatedFilenames());

        System.out.println("Zippe mit PW 7z mit neuerem 7zip");
        ZipFilesWith7Zip zipFilesMitPw3 = new ZipFilesWith7Zip(
                "c:\\temp\\zipping_test3\\7-Zip\\7z.exe");
        zipFilesMitPw3.create7zFile();
        zipFilesMitPw3.cypher("Test"); // Bitte das Passwort nicht wirklich verwenden!
        zipFilesMitPw3.zip(archiveMitPw3);
        System.out.println("Erzeugte Dateien mit PW 7z mit neuerem 7zip: "
                + zipFilesMitPw3.getCreatedFilenames());
        System.out.println("Ausgeführtes Kommando: " + zipFilesMitPw3.getCommand());
    }

}
