package de.duehl.basics.zzzunused.text.html.generation;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.text.Text;

public class ManualIndentationHtmlBuilderTest {

    @Test
    public void creation() {
        ManualIndentationHtmlBuilder builder = new ManualIndentationHtmlBuilder();
        assertNotNull(builder);
    }

    @Test
    public void appendSomethingClearAndGetEmptyResult() {
        ManualIndentationHtmlBuilder builder = new ManualIndentationHtmlBuilder();
        builder.append("foo");
        builder.clear();
        String actual = builder.toString();
        String expected = "";
        assertEquals(expected, actual);
    }

    @Test
    public void withoutContent() {
        ManualIndentationHtmlBuilder builder = new ManualIndentationHtmlBuilder();
        builder.appendHeadWithOwnCssUtf8("Ein tolles HTML-Dokument")
                .appendH1(4, "Überschrift 1")
                .appendH2(4, "Unterpunkt 1.1")
                .appendH2(4, "Unterpunkt 1.2")
                .appendH1(4, "Überschrift 2")
                .appendH2(4, "Unterpunkt 2.1")
                .appendH3(4, "Unterpunkt 2.1.1")
                .appendH1(4, "Überschrift 3")
                .appendH2(4, "Unterpunkt 3.1")
                .appendH3(4, "Unterpunkt 3.1.1")
                .appendH4(4, "Unterpunkt 3.1.1.1")
                .appendH3(4, "Unterpunkt 3.1.2")
                .appendH4(4, "Unterpunkt 3.1.2.1")
                .appendH5(4, "Unterpunkt 3.1.2.1.1")
                .appendH6(4, "Unterpunkt 3.1.2.1.1.1")
                .appendFoot();

        String actual = builder.toString();
        String n = Text.LINE_BREAK;
        String expected = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" "
                + "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">" + n + n
                + "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"de\" lang=\"de\">" + n
                + "<head>" + n
                + "    <title>Ein tolles HTML-Dokument</title>" + n
                + "        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">" + n
                + "    <style>" + Text.LINE_BREAK
                + "        body {" + n
                + "               background-color:#E6E6FF;" + n
                + "               color:#000096;" + n
                + "               font-family:Verdana, sans-serif;" + n
                + "               font-size:14pt;" + n
                + "               margin-left:3%;" + n
                + "               margin-right:3%;" + n
                + "               color:#000096;" + n
                + "             }" + n
                + "        p    {" + n
                + "               font-size:1em;" + n
                + "               font-family:Verdana, sans-serif;" + n
                + "               color:#000096;" + n
                + "             }" + n
                + "        h1   {" + n
                + "               text-align: left;" + n
                + "               font-size: 36pt;" + n
                + "               font-weight: bold;" + n
                + "               color:#000096;" + n
                + "             }" + n
                + "        h2   {" + n
                + "               text-align: left;" + n
                + "               font-size: 24pt;" + n
                + "               font-weight: bold;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:8;" + n
                + "               margin-top:15;" + n
                + "             }" + n
                + "        h3   {" + n
                + "               font-size: 20pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        h4   {" + n
                + "               font-size: 18pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        h5   {" + n
                + "               font-size: 16pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        h6   {" + n
                + "               font-size: 15pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        .monospace { font-family: monospace; }" + n
                + "    </style>" + n + n
                + "</head>" + n + n + n
                + "<body>" + n + n
                + "    <h1 id=\"id1\">Überschrift 1</h1>" + n + n
                + "    <h2 id=\"id1_1\">Unterpunkt 1.1</h2>" + n + n
                + "    <h2 id=\"id1_2\">Unterpunkt 1.2</h2>" + n
                + "    <a href=\"#top\">Zum Seitenanfang</a>" + n + n
                + "    <h1 id=\"id2\">Überschrift 2</h1>" + n + n
                + "    <h2 id=\"id2_3\">Unterpunkt 2.1</h2>" + n + n
                + "    <h3 id=\"id2_3_1\">Unterpunkt 2.1.1</h3>" + n
                + "    <a href=\"#top\">Zum Seitenanfang</a>" + n + n
                + "    <h1 id=\"id3\">Überschrift 3</h1>" + n + n
                + "    <h2 id=\"id3_4\">Unterpunkt 3.1</h2>" + n + n
                + "    <h3 id=\"id3_4_2\">Unterpunkt 3.1.1</h3>" + n + n
                + "    <h4 id=\"id3_4_2_1\">Unterpunkt 3.1.1.1</h4>" + n + n
                + "    <h3 id=\"id3_4_3\">Unterpunkt 3.1.2</h3>" + n + n
                + "    <h4 id=\"id3_4_3_2\">Unterpunkt 3.1.2.1</h4>" + n + n
                + "    <h5 id=\"id3_4_3_2_1\">Unterpunkt 3.1.2.1.1</h5>" + n + n
                + "    <h6 id=\"id3_4_3_2_1_1\">Unterpunkt 3.1.2.1.1.1</h6>" + n + n
                //+ "    <a href=\"#top\">Zum Seitenanfang</a>" + n
                + "</body>" + n
                + "</html>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void content() {
        ManualIndentationHtmlBuilder builder = new ManualIndentationHtmlBuilder();
        builder.appendHeadWithOwnCssUtf8("Ein tolles HTML-Dokument")
                .appendH1(4, "Überschrift 1")
                .appendH2(4, "Unterpunkt 1.1")
                .appendH2(4, "Unterpunkt 1.2")
                .appendH1(4, "Überschrift 2")
                .appendH2(4, "Unterpunkt 2.1")
                .appendH3(4, "Unterpunkt 2.1.1")
                .appendH1(4, "Überschrift 3")
                .appendH2(4, "Unterpunkt 3.1")
                .appendH3(4, "Unterpunkt 3.1.1")
                .appendH4(4, "Unterpunkt 3.1.1.1")
                .appendH3(4, "Unterpunkt 3.1.2")
                .appendH4(4, "Unterpunkt 3.1.2.1")
                .appendH5(4, "Unterpunkt 3.1.2.1.1")
                .appendH6(4, "Unterpunkt 3.1.2.1.1.1")
                .appendFoot()
                .insertContent();

        String actual = builder.toString();
        String n = Text.LINE_BREAK;
        String s = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String expected = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" "
                + "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">" + n + n
                + "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"de\" lang=\"de\">" + n
                + "<head>" + n
                + "    <title>Ein tolles HTML-Dokument</title>" + n
                + "        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">" + n
                + "    <style>" + Text.LINE_BREAK
                + "        body {" + n
                + "               background-color:#E6E6FF;" + n
                + "               color:#000096;" + n
                + "               font-family:Verdana, sans-serif;" + n
                + "               font-size:14pt;" + n
                + "               margin-left:3%;" + n
                + "               margin-right:3%;" + n
                + "               color:#000096;" + n
                + "             }" + n
                + "        p    {" + n
                + "               font-size:1em;" + n
                + "               font-family:Verdana, sans-serif;" + n
                + "               color:#000096;" + n
                + "             }" + n
                + "        h1   {" + n
                + "               text-align: left;" + n
                + "               font-size: 36pt;" + n
                + "               font-weight: bold;" + n
                + "               color:#000096;" + n
                + "             }" + n
                + "        h2   {" + n
                + "               text-align: left;" + n
                + "               font-size: 24pt;" + n
                + "               font-weight: bold;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:8;" + n
                + "               margin-top:15;" + n
                + "             }" + n
                + "        h3   {" + n
                + "               font-size: 20pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        h4   {" + n
                + "               font-size: 18pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        h5   {" + n
                + "               font-size: 16pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        h6   {" + n
                + "               font-size: 15pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        .monospace { font-family: monospace; }" + n
                + "    </style>" + n + n
                + "</head>" + n + n + n
                + "<body>" + n
                + "    <h1>Inhalt</h1>" + n
                + "    <a href=\"#id1\">Überschrift 1</a><br />" + n
                + "    " + s + "<a href=\"#id1_1\">Unterpunkt 1.1</a><br />" + n
                + "    " + s + "<a href=\"#id1_2\">Unterpunkt 1.2</a><br />" + n
                + "    <a href=\"#id2\">Überschrift 2</a><br />" + n
                + "    " + s + "<a href=\"#id2_3\">Unterpunkt 2.1</a><br />" + n
                + "    " + s + s + "<a href=\"#id2_3_1\">Unterpunkt 2.1.1</a><br />" + n
                + "    <a href=\"#id3\">Überschrift 3</a><br />" + n
                + "    " + s + "<a href=\"#id3_4\">Unterpunkt 3.1</a><br />" + n
                + "    " + s + s + "<a href=\"#id3_4_2\">Unterpunkt 3.1.1</a><br />" + n
                + "    " + s + s + s + "<a href=\"#id3_4_2_1\">Unterpunkt 3.1.1.1</a><br />" + n
                + "    " + s + s + "<a href=\"#id3_4_3\">Unterpunkt 3.1.2</a><br />" + n
                + "    " + s + s + s + "<a href=\"#id3_4_3_2\">Unterpunkt 3.1.2.1</a><br />" + n
                + "    " + s + s + s + s + "<a href=\"#id3_4_3_2_1\">Unterpunkt 3.1.2.1.1</a><br />" + n
                + "    " + s + s + s + s + s + "<a href=\"#id3_4_3_2_1_1\">Unterpunkt 3.1.2.1.1.1</a><br />" + n + n + n
                + "    <h1 id=\"id1\">Überschrift 1</h1>" + n + n
                + "    <h2 id=\"id1_1\">Unterpunkt 1.1</h2>" + n + n
                + "    <h2 id=\"id1_2\">Unterpunkt 1.2</h2>" + n
                + "    <a href=\"#top\">Zum Seitenanfang</a>" + n + n
                + "    <h1 id=\"id2\">Überschrift 2</h1>" + n + n
                + "    <h2 id=\"id2_3\">Unterpunkt 2.1</h2>" + n + n
                + "    <h3 id=\"id2_3_1\">Unterpunkt 2.1.1</h3>" + n
                + "    <a href=\"#top\">Zum Seitenanfang</a>" + n + n
                + "    <h1 id=\"id3\">Überschrift 3</h1>" + n + n
                + "    <h2 id=\"id3_4\">Unterpunkt 3.1</h2>" + n + n
                + "    <h3 id=\"id3_4_2\">Unterpunkt 3.1.1</h3>" + n + n
                + "    <h4 id=\"id3_4_2_1\">Unterpunkt 3.1.1.1</h4>" + n + n
                + "    <h3 id=\"id3_4_3\">Unterpunkt 3.1.2</h3>" + n + n
                + "    <h4 id=\"id3_4_3_2\">Unterpunkt 3.1.2.1</h4>" + n + n
                + "    <h5 id=\"id3_4_3_2_1\">Unterpunkt 3.1.2.1.1</h5>" + n + n
                + "    <h6 id=\"id3_4_3_2_1_1\">Unterpunkt 3.1.2.1.1.1</h6>" + n + n
                //+ "    <a href=\"#top\">Zum Seitenanfang</a>" + n
                + "</body>" + n
                + "</html>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void contentAtEnd() {
        ManualIndentationHtmlBuilder builder = new ManualIndentationHtmlBuilder();
        builder.appendHeadWithOwnCssUtf8("Ein tolles HTML-Dokument")
                .appendH1(4, "Überschrift 1")
                .appendH2(4, "Unterpunkt 1.1")
                .appendH2(4, "Unterpunkt 1.2")
                .appendH1(4, "Überschrift 2")
                .appendH2(4, "Unterpunkt 2.1")
                .appendH3(4, "Unterpunkt 2.1.1")
                .appendH1(4, "Überschrift 3")
                .appendH2(4, "Unterpunkt 3.1")
                .appendH3(4, "Unterpunkt 3.1.1")
                .appendH4(4, "Unterpunkt 3.1.1.1")
                .appendH3(4, "Unterpunkt 3.1.2")
                .appendH4(4, "Unterpunkt 3.1.2.1")
                .appendH5(4, "Unterpunkt 3.1.2.1.1")
                .appendH6(4, "Unterpunkt 3.1.2.1.1.1")
                .appendFoot()
                .insertContentAtEnd();

        String actual = builder.toString();
        String n = Text.LINE_BREAK;
        String s = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String expected = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" "
                + "\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">" + n + n
                + "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"de\" lang=\"de\">" + n
                + "<head>" + n
                + "    <title>Ein tolles HTML-Dokument</title>" + n
                + "        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">" + n
                + "    <style>" + Text.LINE_BREAK
                + "        body {" + n
                + "               background-color:#E6E6FF;" + n
                + "               color:#000096;" + n
                + "               font-family:Verdana, sans-serif;" + n
                + "               font-size:14pt;" + n
                + "               margin-left:3%;" + n
                + "               margin-right:3%;" + n
                + "               color:#000096;" + n
                + "             }" + n
                + "        p    {" + n
                + "               font-size:1em;" + n
                + "               font-family:Verdana, sans-serif;" + n
                + "               color:#000096;" + n
                + "             }" + n
                + "        h1   {" + n
                + "               text-align: left;" + n
                + "               font-size: 36pt;" + n
                + "               font-weight: bold;" + n
                + "               color:#000096;" + n
                + "             }" + n
                + "        h2   {" + n
                + "               text-align: left;" + n
                + "               font-size: 24pt;" + n
                + "               font-weight: bold;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:8;" + n
                + "               margin-top:15;" + n
                + "             }" + n
                + "        h3   {" + n
                + "               font-size: 20pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        h4   {" + n
                + "               font-size: 18pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        h5   {" + n
                + "               font-size: 16pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        h6   {" + n
                + "               font-size: 15pt;" + n
                + "               color:#000096;" + n
                + "               margin-bottom:0;" + n
                + "             }" + n
                + "        .monospace { font-family: monospace; }" + n
                + "    </style>" + n + n
                + "</head>" + n + n + n
                + "<body>" + n + n
                + "    <h1 id=\"id1\">Überschrift 1</h1>" + n + n
                + "    <h2 id=\"id1_1\">Unterpunkt 1.1</h2>" + n + n
                + "    <h2 id=\"id1_2\">Unterpunkt 1.2</h2>" + n
                + "    <a href=\"#top\">Zum Seitenanfang</a>" + n + n
                + "    <h1 id=\"id2\">Überschrift 2</h1>" + n + n
                + "    <h2 id=\"id2_3\">Unterpunkt 2.1</h2>" + n + n
                + "    <h3 id=\"id2_3_1\">Unterpunkt 2.1.1</h3>" + n
                + "    <a href=\"#top\">Zum Seitenanfang</a>" + n + n
                + "    <h1 id=\"id3\">Überschrift 3</h1>" + n + n
                + "    <h2 id=\"id3_4\">Unterpunkt 3.1</h2>" + n + n
                + "    <h3 id=\"id3_4_2\">Unterpunkt 3.1.1</h3>" + n + n
                + "    <h4 id=\"id3_4_2_1\">Unterpunkt 3.1.1.1</h4>" + n + n
                + "    <h3 id=\"id3_4_3\">Unterpunkt 3.1.2</h3>" + n + n
                + "    <h4 id=\"id3_4_3_2\">Unterpunkt 3.1.2.1</h4>" + n + n
                + "    <h5 id=\"id3_4_3_2_1\">Unterpunkt 3.1.2.1.1</h5>" + n + n
                + "    <h6 id=\"id3_4_3_2_1_1\">Unterpunkt 3.1.2.1.1.1</h6>" + n + n
                //+ "    <a href=\"#top\">Zum Seitenanfang</a>" + n + n
                + n
                + "    <h1>Inhalt</h1>" + n
                + "    <a href=\"#id1\">Überschrift 1</a><br />" + n
                + "    " + s + "<a href=\"#id1_1\">Unterpunkt 1.1</a><br />" + n
                + "    " + s + "<a href=\"#id1_2\">Unterpunkt 1.2</a><br />" + n
                + "    <a href=\"#id2\">Überschrift 2</a><br />" + n
                + "    " + s + "<a href=\"#id2_3\">Unterpunkt 2.1</a><br />" + n
                + "    " + s + s + "<a href=\"#id2_3_1\">Unterpunkt 2.1.1</a><br />" + n
                + "    <a href=\"#id3\">Überschrift 3</a><br />" + n
                + "    " + s + "<a href=\"#id3_4\">Unterpunkt 3.1</a><br />" + n
                + "    " + s + s + "<a href=\"#id3_4_2\">Unterpunkt 3.1.1</a><br />" + n
                + "    " + s + s + s + "<a href=\"#id3_4_2_1\">Unterpunkt 3.1.1.1</a><br />" + n
                + "    " + s + s + "<a href=\"#id3_4_3\">Unterpunkt 3.1.2</a><br />" + n
                + "    " + s + s + s + "<a href=\"#id3_4_3_2\">Unterpunkt 3.1.2.1</a><br />" + n
                + "    " + s + s + s + s + "<a href=\"#id3_4_3_2_1\">Unterpunkt 3.1.2.1.1</a><br />" + n
                + "    " + s + s + s + s + s + "<a href=\"#id3_4_3_2_1_1\">Unterpunkt 3.1.2.1.1.1</a><br />" + n + n
                + "</body>" + n
                + "</html>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendOpeningOl() {
        ManualIndentationHtmlBuilder builder = new ManualIndentationHtmlBuilder();
        builder.appendOpeningOl();
        builder.appendLi(4, "foo");
        builder.appendLi(4, "bar");
        builder.appendLi(4, "baz");
        builder.appendClosingOl();

        String actual = builder.toString();
        String n = Text.LINE_BREAK;
        String expected = "<ol>" + n
                + "    <li>foo</li>" + n
                + "    <li>bar</li>" + n
                + "    <li>baz</li>" + n
                + "</ol>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendOpeningOlIndented() {
        ManualIndentationHtmlBuilder builder = new ManualIndentationHtmlBuilder();
        builder.appendOpeningOl(4);
        builder.appendLi(8, "foo");
        builder.appendLi(8, "bar");
        builder.appendLi(8, "baz");
        builder.appendClosingOl(4);

        String actual = builder.toString();
        String n = Text.LINE_BREAK;
        String expected = "    <ol>" + n
                + "        <li>foo</li>" + n
                + "        <li>bar</li>" + n
                + "        <li>baz</li>" + n
                + "    </ol>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendOpeningOlStart() {
        ManualIndentationHtmlBuilder builder = new ManualIndentationHtmlBuilder();
        builder.appendOpeningOlStart(15);
        builder.appendLi(4, "foo");
        builder.appendLi(4, "bar");
        builder.appendLi(4, "baz");
        builder.appendClosingOl();

        String actual = builder.toString();
        String n = Text.LINE_BREAK;
        String expected = "<ol start=\"15\">" + n
                + "    <li>foo</li>" + n
                + "    <li>bar</li>" + n
                + "    <li>baz</li>" + n
                + "</ol>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendOpeningOlStartIndented() {
        ManualIndentationHtmlBuilder builder = new ManualIndentationHtmlBuilder();
        builder.appendOpeningOlStart(4, 15);
        builder.appendLi(8, "foo");
        builder.appendLi(8, "bar");
        builder.appendLi(8, "baz");
        builder.appendClosingOl(4);

        String actual = builder.toString();
        String n = Text.LINE_BREAK;
        String expected = "    <ol start=\"15\">" + n
                + "        <li>foo</li>" + n
                + "        <li>bar</li>" + n
                + "        <li>baz</li>" + n
                + "    </ol>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLink() {
        ManualIndentationHtmlBuilder html = new ManualIndentationHtmlBuilder();
        html.appendLink(12, "http://www.heinsundpartner.de", "Heins + Partner GmbH");

        String actual = html.toString();
        String n = Text.LINE_BREAK;
        String expected = "            <a href=\"http://www.heinsundpartner.de\">"
                + "Heins + Partner GmbH</a>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLn() {
        ManualIndentationHtmlBuilder html = new ManualIndentationHtmlBuilder();
        html.appendLn("foo bar baz");

        String actual = html.toString();
        String n = Text.LINE_BREAK;
        String expected = "foo bar baz" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLnWithSpaces() {
        ManualIndentationHtmlBuilder html = new ManualIndentationHtmlBuilder();
        html.appendLn(12, "foo bar baz");

        String actual = html.toString();
        String n = Text.LINE_BREAK;
        String expected = "            foo bar baz" + n;
        assertEquals(expected, actual);
    }

    // TODO mehr testen!

}
