package de.duehl.html.download.start;

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.logging.LogEntry;
import de.duehl.basics.logging.MemoryLogger;
import de.duehl.html.download.DownloaderWithOwnRedirectHandling;
import de.duehl.html.download.data.DownloadInfo;
import de.duehl.html.download.data.DownloadInfoWithRedirects;
import de.duehl.html.download.proxy.DownloadProxyList;
import de.duehl.html.download.proxy.Proxy;

public class RunImpressumDownloaderDuehlDeUmlaut {

    public static void main(String[] args) {
        String url = "http://www.dühl.de/";
        MemoryLogger logger = new MemoryLogger();
        DownloadInfoWithRedirects infoWR = DownloaderWithOwnRedirectHandling.download(url,
                createDownloadProxis(), logger);

        List<DownloadInfo> hops = infoWR.getInfosOfEachHop();
        System.out.println("Originale Url       : " + infoWR.getUrl());
        System.out.println("Anzahl Hops         : " + hops.size());
        System.out.println("Lief auf T-Online   : " + infoWR.isRedirectToNavigationshilfeTOnline());
        System.out.println("Letzte Url          : " + infoWR.getTargetUrl());

        int count = 0;
        for (DownloadInfo info: hops) {
            System.out.println("\nHop Nummer " + ++count);
            System.out.println("    Status              : " + info.getStatus().getStatusCode() + " - "
                    + info.getStatus().getDescription());
            System.out.println("    Original-Status-Code: " + info.getOriginalHttpStatusCode());
            System.out.println("    Originale Url       : " + info.getUrl());
            System.out.println("    Returned Url        : " + info.getReturnedUrl());
            System.out.println("    Ist Weiterleitung   : " + info.isRedirect());
            System.out.println("    Weiterleitung nach  : " + info.getRedirectUrlToFollow());
            System.out.println("\n    Seitentext:\n" + info.getContent());
        }


        System.out.println(LogEntry.toNiceString(logger.getLogEntries()));
    }

    private static DownloadProxyList createDownloadProxis() {
        return new DownloadProxyList() {
            @Override
            public List<Proxy> getDownloadProxies() {
                List<Proxy> proxies = new ArrayList<>();
                proxies.add(new Proxy("192.168.32.40", 3128));
                proxies.add(new Proxy("192.168.32.43", 3128));
                return proxies;
            }
        };
    }

}
