package de.duehl.swing.ui.buttons.painted.state;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;

import de.duehl.swing.ui.buttons.painted.PaintedButton;

/**
 * Diese Klasse stellt die Basisklasse für die selbstgezeichneten Buttons dar, welche zwischen
 * ausgewähltem und nicht ausgewähltem Zustand unterscheiden können.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public abstract class PaintedStateButton extends PaintedButton {

    private static final long serialVersionUID = 1L;

    /**
     * Gibt an, ob der Button ausgewählt dargestellt wird. Dann ist das Symbol ausgefüllt, sonst
     * nur eine Umrisslinie.
     */
    private boolean elected;

    /** Konstruktor mit schwarzer Farbe. */
    public PaintedStateButton() {
        this(Color.BLACK);
    }

    /**
     * Konstruktor.
     *
     * @param color
     *            Die Farbe.
     */
    public PaintedStateButton(Color color) {
        super();
        elected = false;
    }

    /**
     * Gibt an, ob der Button ausgewählt dargestellt wird. Dann ist das Symbol ausgefüllt, sonst
     * nur eine Umrisslinie.
     */
    public final boolean isElected() {
        return elected;
    }

    /**
     * Legt fest, ob der Button ausgewählt dargestellt wird. Dann ist das Symbol ausgefüllt, sonst
     * nur eine Umrisslinie.
     */
    public final void setElected(boolean elected) {
        this.elected = elected;
        repaint();
    }

    /** Schaltet zwischen ausgewählt und nicht ausgewählt um. */
    public final void toggleElected() {
        setElected(!elected);
    }

}
