package de.duehl.swing.ui.components.selections.datetime.spinnermodels;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

/**
 * Diese Klasse stellt das Modell für einen Spinner dar, in dem man eine Minute im fünfzehn
 * Minuten Takt (also "00", "15, "30" oder "45") auswählen kann.
 *
 * @version 1.01     2017-03-17
 * @author Christian Dühl
 */

public class QuarterlyMinuteSpinnerModel extends CyclingSpinnerListModel<String> {

    private static final long serialVersionUID = 1L;

    public QuarterlyMinuteSpinnerModel() {
        super(createQuartlyMinutes());
    }

    private static List<String> createQuartlyMinutes() {
        List<String> list = new ArrayList<>();

        for (int minute = 0; minute < 60; minute += 15) {
            String minuteString = Integer.toString(minute);
            if (minuteString.length() < 2) {
                minuteString = "0"  + minuteString;
            }
            list.add(minuteString);
        }

        return list;
    }

}
