package de.duehl.swing.ui.dialogs;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JLabel;

import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.elements.search.SearchPanel;
import de.duehl.swing.ui.elements.search.SearchReaktor;

/**
 * Diese Klasse stellt den Suchdialog dar.
 *
 * @version 1.01     2017-12-15
 * @author Christian Dühl
 */

public class SearchDialog extends ModalDialogBase {

    private static final Dimension DIALOG_DIMENSION = new Dimension(600, 120);

    private SearchReaktor searchReaktor;

    public SearchDialog(SearchReaktor searchReaktor) {
        super("Suche", DIALOG_DIMENSION);
        this.searchReaktor = searchReaktor;
        fillDialog();
    }

    @Override
    protected void populateDialog() {
        add(createTitlePart(), BorderLayout.NORTH);
        add(createSearchPart(), BorderLayout.SOUTH);
    }

    private Component createTitlePart() {
        JLabel label = new JLabel("<html>"
                + "Bite den Suchbegriff eingeben. Ein Klick auf \"Suche\" beginnt "
                + "an der aktuellen Position nach dem eingegebene Begriff zu suchen, ein Klick "
                + "auf \"Weitersuchen\" sucht den zuletzt gesuchten Begriff ab der zuletzt "
                + "gefundenen Position weiter."
                + "</html>");
        return label;
    }

    private Component createSearchPart() {
        return new SearchPanel(searchReaktor);
    }

}
