package de.duehl.swing.ui.elements.navigator.list;

/*
 * Copyright 2023 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für ein Objekt, das ein bestimmtes Listenelement angezeigt.
 *
 * @version 1.02     2023-12-13
 * @author Christian Dühl
 */

public interface ListNavigatorDataUser<DataType> {

    /**
     * Zeigt ein bestimmtes Listenelement an.
     *
     * @param data
     *            Das anzuzeigende Element.
     */
    void showDatasetFromListNavigator(DataType data);

}
