package de.duehl.swing.ui.filter.project.gateway.data;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse hält die (eindeutige) Beschreibung einer Filtermethode zusammen mit ihrem im
 * die Filter nutzenden Projekt definierten FilterTypen.
 *
 * @version 1.01     2020-11-03
 * @author Christian Dühl
 */

public class DescriptionAndFilterType<Type> {

    /** Eindeutige Beschreibung des Filters. */
    private final String description;

    /** Typ des Filters im nutzenden Projekt. */
    private final Type filterType;

    /**
     * Konstruktor.
     *
     * @param description
     *            Eindeutige Beschreibung des Filters.
     * @param filterType
     *            Typ des Filters im nutzenden Projekt.
     */
    public DescriptionAndFilterType(String description, Type filterType) {
        this.description = description;
        this.filterType = filterType;
    }

    /** Getter für die eindeutige Beschreibung des Filters. */
    public String getDescription() {
        return description;
    }

    /** Getter für den Typ des Filters im nutzenden Projekt. */
    public Type getFilterType() {
        return filterType;
    }

    @Override
    public String toString() {
        return "DescriptionAndFilterType [description=" + description + ", filterType=" + filterType
                + "]";
    }

}
