package de.duehl.swing.ui.geometry;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse steht für einen zweidimensionalen Punkt in Pixeln.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public class PixelLine {

    /** Der Startpunkt der Linie. */
    private final PixelPoint start;

    /** Der Endpunkt der Linie. */
    private final PixelPoint end;

    /**
     * Konstruktor.
     *
     * @param start
     *            Der Startpunkt der Linie.
     * @param end
     *            Der Endpunkt der Linie.
     */
    public PixelLine(PixelPoint start, PixelPoint end) {
        this.start = start;
        this.end = end;
    }

    /** Getter für den Startpunkt der Linie. */
    public PixelPoint getStart() {
        return start;
    }

    /** Getter für den Endpunkt der Linie. */
    public PixelPoint getEnd() {
        return end;
    }

    @Override
    public String toString() {
        return "PixelLine [start=" + start + ", end=" + end + "]";
    }

}
