package de.duehl.swing.ui.highlightingeditor.syntax.data;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

public class TokenWithPosition implements Comparable<TokenWithPosition> {

    private final String text;

    private final int textPosition;

    public TokenWithPosition(String text, int textPosition) {
        this.text = text;
        this.textPosition = textPosition;
    }

    public String getText() {
        return text;
    }

    public int getTextPosition() {
        return textPosition;
    }

    @Override
    public String toString() {
        return "TextWithPosition [text=" + text + ", textPosition=" + textPosition + "]";
    }

    @Override
    public int compareTo(TokenWithPosition that) {
        return this.textPosition - that.textPosition;
    }
}
