package de.duehl.swing.ui.highlightingeditor.syntax.highlighting;

import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.highlightingeditor.syntax.SyntaxHighlighting;

/**
 * Diese Klasse erzeugt Syntax-Highlightings.
 *
 * @version 1.01     2017-11-23
 * @author Christian Dühl
 */

public class HighlightingFactory {

    /* Konstanten für die vorhandenen Syntax-Highlightings: */
    public static final String JAVA = "JAVA";
    public static final String WZ_PREPARATION = "WZ_PREPARATION";

    /** Liste aller vorhandenen Syntax-Highlightings. */
    private static final List<String> ALL_HIGHLIGHTINGS = CollectionsHelper.buildListFrom(JAVA,
            WZ_PREPARATION);

    /** Gibt eine Liste aller bekannter Syntax-Highlightings zurück. */
    public List<String> getAllKnownHighlightingNames() {
        return ALL_HIGHLIGHTINGS;
    }

    /**
     * Erzeugt ein Syntax-Highlighting.
     *
     * @param highlightingName
     *            Name des gewünschten Syntax-Highlightings.
     * @return Syntax-Highlighting
     */
    public SyntaxHighlighting create(String highlightingName) {
        switch (highlightingName) {
            case JAVA:
                return new JavaSyntaxHighlighting().create();
            case WZ_PREPARATION:
                return new WzPreparationHighlighting().create();
            default:
                throw new IllegalArgumentException("Zum Namen '" + highlightingName
                        + "' ist keine Methode zur Syntax-Hervorhebung bekannt.");
        }
    }

}
