package de.duehl.swing.ui.highlightingeditor.syntax.highlighting;

import java.awt.Color;
import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.colors.NamedColorListFabric;
import de.duehl.swing.ui.highlightingeditor.syntax.HighlightingTokens;
import de.duehl.swing.ui.highlightingeditor.syntax.HighlightingType;
import de.duehl.swing.ui.highlightingeditor.syntax.SyntaxHighlighting;

/**
 * Diese Klasse stellt das Syntax-Highlighting für die WZ-Vorarbeiten dar.
 *
 * @version 1.01     2017-11-23
 * @author Christian Dühl
 */

class WzPreparationHighlighting implements Highlighting {

    private final SyntaxHighlighting sytaxHighlighting;

    WzPreparationHighlighting() {
        HighlightingType keywordsHighlightingType = createKeywordHighlightingType();
        HighlightingType symbolsHighlightingType = createSymbolHighlightingType();
        sytaxHighlighting = new SyntaxHighlighting(keywordsHighlightingType,
                symbolsHighlightingType);

        addKeywords();
        addSymbols();
        addOther();
    }

    private static HighlightingType createKeywordHighlightingType() {
        return new HighlightingType(createColor(NamedColorListFabric.AUBERGINE), true);
    }

    private static HighlightingType createSymbolHighlightingType() {
        return new HighlightingType(createColor(NamedColorListFabric.FORESTGREEN), false, true);
    }

    private static Color createColor(String colorName) {
        return new NamedColorListFabric().getColorByName(colorName);
    }

    private void addKeywords() {
        List<String> keywords = CollectionsHelper.buildListFrom();

        for (String keyword : keywords) {
            sytaxHighlighting.addKeyword(keyword);
        }
    }

    private void addSymbols() {
        List<String> symbols = CollectionsHelper.buildListFrom();

        for (String symbol : symbols) {
            sytaxHighlighting.addSymbol(symbol);
        }
    }

    private void addOther() {
        /*
         * Anforderungen:
         *
         *  - i/I (gelb)
         *  - l/L (grün)
         *  - O/o (blau)
         *  - 0/1 (rot)
         *  - ae/oe/ue (rosa)
         *  - ss (lila)
         */

        addOther(NamedColorListFabric.GOLD, "i", "I");
        addOther(NamedColorListFabric.GREEN, "l", "L");
        addOther(NamedColorListFabric.RED, "0", "1");
        addOther(NamedColorListFabric.HOTPINK, "ae", "oe", "ue", "Ae", "Oe", "Ue");
        addOther(NamedColorListFabric.BLUE, "O", "o");
        addOther(NamedColorListFabric.DARKMAGENTA, "ss");
    }

    private void addOther(String colorName, String ... parts) {
        HighlightingType type = new HighlightingType(createColor(colorName), true, true);

        HighlightingTokens tokens = new HighlightingTokens(type);
        for (String part : parts) {
            tokens.addToken(part);
        }
        sytaxHighlighting.addOtherHighlightingTokens(tokens);
    }

    @Override
    public SyntaxHighlighting create() {
        return sytaxHighlighting;
    }

}
