package de.duehl.swing.ui.layout;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Diese Klasse erstellt einen JPanel in dem ein Objekt Zentriert und nicht den Platz konsumierend
 * dargestellt wird.
 *
 * @version 1.01     2019-05-27
 * @author Christian Dühl
 */

public class FixedCenter {

    private final Component center;

    public FixedCenter(Component center) {
        this.center = center;
    }

    public JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets     = new Insets(0, 0, 0, 0);
        gbc.fill       = GridBagConstraints.BOTH;
        gbc.anchor     = GridBagConstraints.WEST;
        gbc.weightx    = 0.0;
        gbc.weighty    = 0.0;
        gbc.gridy      = 0;

        /* Freiraum links: */
        gbc.gridx      = 0;
        gbc.weightx    = 1.0;
        panel.add(new JLabel(), gbc);

        /* Dateioperationen: */
        gbc.gridx      = 1;
        gbc.weightx    = 0.0;
        panel.add(center, gbc);

        /* Freiraum rechts: */
        gbc.gridx      = 2;
        gbc.weightx    = 1.0;
        panel.add(new JLabel(), gbc);

        return panel;
    }

}
