package de.duehl.swing.ui.start.filter;

/*
 * Copyright 2010 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.filter.dialog.FilterCombinationDialog;
import de.duehl.swing.ui.filter.method.Method;
import de.duehl.swing.ui.filter.method.MethodCombination;
import de.duehl.swing.ui.filter.method.combination.CombinationElement;
import de.duehl.swing.ui.filter.method.combination.CombinationElementList;
import de.duehl.swing.ui.start.filter.project.DemoLinesCreater;
import de.duehl.swing.ui.start.filter.project.data.TestFilterData;
import de.duehl.swing.ui.start.filter.project.gateway.TestFilterGateway;
import de.duehl.swing.ui.start.filter.project.gateway.TestFilterMethodFabric;
import de.duehl.swing.ui.start.filter.project.gateway.TestFilterType;

/**
 * Diese Klasse testet den Dialog zur Erzeugung eines Filters.
 *
 * @version 1.01     2020-11-05
 * @author Christian Dühl
 */

public class FilterDialogTest extends NonModalFrameDialogBase {

    private static final Dimension DIALOG_DIMENSION = new Dimension(400, 200);
    private static final String FILTER_DIRECTORY = "c:/temp/filter";

    private final JButton filterDialogButton;

    /** Konstruktor. */
    public FilterDialogTest() {
        super("Filter-Dialog Test", DIALOG_DIMENSION);

        filterDialogButton = new JButton("Filter-Dialog öffnen");
        initFilterDialogButton();

        fillDialog();
    }

    /** Baut die Gui auf. */
    @Override
    protected void populateDialog() {
        add(filterDialogButton, BorderLayout.CENTER);
    }

    private void initFilterDialogButton() {
        filterDialogButton.addActionListener(e -> openFilterDialog());
    }

    private void openFilterDialog() {
        try {
            tryToOpenFilterDialog();
        }
        catch (Exception exception) {
            createErrorHandler().error("Fehler beim Aufruf des Filter-Dialogs:", exception);
        }
    }

    private void tryToOpenFilterDialog() {
        TestFilterGateway filterMethods = new TestFilterGateway(elements -> workWithFilter(elements));
        TestFilterMethodFabric<TestFilterData, TestFilterType> filterMethodFabric =
                new TestFilterMethodFabric<TestFilterData, TestFilterType>();
        FilterCombinationDialog<TestFilterData, TestFilterType> dialog =
                new FilterCombinationDialog<TestFilterData, TestFilterType>(
                getLocation(), getProgramImage(), filterMethods, filterMethodFabric,
                FILTER_DIRECTORY, createErrorHandler());
        dialog.setVisible(true);

        closeDialog();
    }

    private void workWithFilter(CombinationElementList<TestFilterData> elements) {
        List<TestFilterData> datasets = DemoLinesCreater.createDemoDatasets();

        System.out.println("Angewendeter Filter: ");
        for (CombinationElement<TestFilterData> element : elements) {
            System.out.println("    " + element);
        }

        Method<TestFilterData> method = new MethodCombination<>(elements);
        List<Integer> filter = method.buildFilter(datasets);
        System.out.println("Filter:");
        for (int number : filter) {
            System.out.println("    Nummer " + number);
        }

        List<TestFilterData> filteredDatasets = new ArrayList<>();
        for (int number : filter) {
            filteredDatasets.add(datasets.get(number - 1));
        }
        System.out.println("Gefilterte Datensätze:");
        for (TestFilterData data : filteredDatasets) {
            System.out.println("    " + data);
        }
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();
        new FilterDialogTest().setVisible(true);
    }

}
