package de.duehl.swing.ui.start.listdialog;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Dimension;
import java.awt.Point;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.lists.EditableListDialog;
import de.duehl.swing.ui.dialogs.lists.ui.EditableListElement;
import de.duehl.swing.ui.start.listdialog.logic.DemoLogicalElement;
import de.duehl.swing.ui.start.listdialog.logic.DemoLogicalList;
import de.duehl.swing.ui.start.listdialog.ui.DemoUiElement;

public class EditableListDialogDemo extends EditableListDialog<DemoLogicalElement> {

    private static final Dimension DIALOG_DIMENSION = new Dimension(600, 500);

    public EditableListDialogDemo(DemoLogicalList logicalList) {
        super(DIALOG_DIMENSION, new Point(400, 350), null, "Demo-Titel", "Deme-Elemente",
                logicalList);
        fillDialog();
    }

    @Override
    protected EditableListElement<DemoLogicalElement> createUiElement(DemoLogicalElement element) {
        return new DemoUiElement(element, getLogicalList(), this);
    }

    @Override
    protected DemoLogicalElement createNewElement() {
        return new DemoLogicalElement("");
    }

    public static void main(String[] args) {
        DemoLogicalList list = new DemoLogicalList();
        list.add(new DemoLogicalElement("Apfel"));
        list.add(new DemoLogicalElement("Birne"));
        list.add(new DemoLogicalElement("Orange"));

        GuiTools.setNiceLayoutManager();

        EditableListDialogDemo dialog = new EditableListDialogDemo(list);
        dialog.setVisible(true);
        System.out.println("Änderungen: " + dialog.isDataChanged());
    }

}
