package de.duehl.swing.ui.start.search;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;

import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.elements.search.SearchPanel;
import de.duehl.swing.ui.elements.search.SearchReaktor;

/**
 * Diese Klasse testet das EnterTextField-Element.
 *
 * @version 1.01     2017-12-15
 * @author Christian Dühl
 */

public class SearchPanelTest {

    /** Der zu testende Such-Panel. */
    private SearchPanel searchPanel;

    /** Konstruktor. */
    public SearchPanelTest() {
        searchPanel = new SearchPanel(createSearchReaktor());
        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private SearchReaktor createSearchReaktor() {
        return new SearchReaktor() {
            @Override
            public void search(String text) {
                System.out.println("Suchen nach '" + text + "'");
            }

            @Override
            public void searchAgain() {
                System.out.println("Weitersuchen");
            }
        };
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("SearchPanel Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(searchPanel, BorderLayout.NORTH);

        frame.setPreferredSize(new Dimension(900, 100));
        frame.pack();
        frame.setVisible(true);
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new SearchPanelTest();
    }

}

