package de.duehl.swing.ui.start.tabbars;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.basics.io.Charset;
import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;
import de.duehl.swing.ui.tabs.Tabulator;
import de.duehl.swing.ui.tabs.bars.editors.TabBarWithEditors;
import de.duehl.swing.ui.tabs.elements.TabElementsWithEditor;

/**
 * Diese Klasse testet die TabBar-Elemente.
 *
 * @version 1.01     2017-11-21
 * @author Christian Dühl
 */

public class TabBarWithEditorsTest {

    /** Die zu testenden Reiter. */
    private TabBarWithEditors tabBar;

    /** Konstruktor. */
    public TabBarWithEditorsTest() {
        tabBar = new TabBarWithEditors();
        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("Tab BarWith Editors Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new GridLayout(0,  1));

        frame.add(createTabBar());

        frame.setPreferredSize(new Dimension(800, 600));
        frame.pack();
        frame.setVisible(true);
    }

    private Component createTabBar() {
        addTab("c:/temp/swing_test/Äpfel.txt");
        addTab("c:/temp/swing_test/Birnen.txt", Charset.UTF_8);
        addTab("c:/temp/swing_test/Pflaumen.txt", Charset.UTF_8);

        tabBar.focusSelectedEditor();

        return tabBar.getComponent();
    }

    private void addTab(String filename) {
        addTab(filename, HighlightingEditor.DEFAULT_CHARSET);
    }

    private void addTab(String filename, Charset charset) {
        HighlightingEditor editor = createEditor();
        editor.openFile(filename, charset);
        addEditorToTab(editor);
    }

    private HighlightingEditor createEditor() {
        HighlightingEditor editor = new HighlightingEditor();
        editor.useMonospaceFont();
        editor.setFontSize(20);
        return editor;
    }

    private void addEditorToTab(HighlightingEditor editor) {
        TabElementsWithEditor tabElements = tabBar.addTab(editor);
        Tabulator tabulator = tabElements.getTabulator();
        editor.addChangeStateDisplayer(tabulator);
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new TabBarWithEditorsTest();
    }

}

