package de.duehl.vocabulary.japanese.common.persistence;

import java.awt.Color;

/**
 * Dieses Interface bietet Methoden zu den Farben an, die man braucht, um bestimmte Teile der
 * Vokabel darzustellen.
 *
 * Hier geht es dabei um die Farben der Romaji und der Aussprache.
 *
 * @version 1.01     2024-08-15
 * @author Christian Dühl
 */

public interface RomajiAndPronunciationColorOptions {

    /** Getter für die Farbe für normalen Text bei der Darstellung einer Vokabel. */
    Color getVocableColorStandard();

    /** Getter für die Farbe für die Romaji bei der Darstellung einer Vokabel. */
    Color getVocableColorRomaji();

    /** Getter für die Farbe für die Aussprache bei der Darstellung einer Vokabel. */
    Color getVocableColorPronunciation();

}
