package de.duehl.vocabulary.japanese.logic.symbol.kana.internal;

import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;

/**
 * Dieses Interface steht für ein Objekt, das zu einem Kana die internen, benutzerabhängigen
 * Daten abrufen kann.
 *
 * @version 1.01     2025-02-02
 * @author Christian Dühl
 */

public interface InternalKanaDataRequester {

    /**
     * Gibt die internen Daten zum übergebenen Hiragana zurück.
     *
     * Sind zu der Hiragana keine internen Daten hinterlegt, so wird eine Ausnahme geworfen.
     *
     * @param hiragana
     *            Die Hiragana zu der man die internen Daten ermitteln möchte.
     * @return Die internen Daten zur übergebenen Hiragana.
     */
    InternalAdditionalKanaData getInternalDataForHiragana(Hiragana hiragana);

    /**
     * Gibt die internen Daten zum übergebenen Katakana zurück.
     *
     * Sind zu der Katakana keine internen Daten hinterlegt, so wird eine Ausnahme geworfen.
     *
     * @param hiragana
     *            Die Katakana zu der man die internen Daten ermitteln möchte.
     * @return Die internen Daten zur übergebenen Katakana.
     */
    InternalAdditionalKanaData getInternalDataForKatakana(Katakana katakana);

}
