package de.duehl.vocabulary.japanese.start;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.launcher.SecretParameterForTrainerStart;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;

/**
 * Diese Klasse startet den Vokabel-Trainer.
 *
 * @version 1.01     2024-11-11
 * @author Christian Dühl
 */

public class StartVocabularyTrainer {

    public static void main(String[] args) {
        if (args.length != 1 || !args[0].equals(SecretParameterForTrainerStart.SECRET_PARAMETER)) {
            String title = "";
            String message = ""
                    + "Bitte den Launcher de.duehl.vocabulary.japanese.launcher_NUMMER.jar,\n"
                    + "wobei NUMMER die höchste vorhandene Versionsnummer darstellt, statt\n"
                    + "des Vokabeltrainers direkt aufrufen.";
            GuiTools.informUser(title, message);
        }
        else {
            new VocabularyTrainerLogic().run();
        }
    }

}
