package de.duehl.vocabulary.japanese.ui.data;

import java.util.List;

import de.duehl.vocabulary.japanese.data.Vocable;

/**
 * Dieses Interface steht für ein Objekt, das alle Vokabeln, welche einer bestimmten Bedingung
 * entsprechen, anzeigt.
 *
 * @version 1.01     2024-10-26
 * @author Christian Dühl
 */

public interface VocablesWithSpecificConstraintLister {

    /**
     * Findet alle Vokabeln, die einer bestimmten Bedingung genügen.
     *
     * @param description
     *            Die Beschreibung der Menge von Vokabeln (wie sie der VocabularyListerDialog
     *            erwartet, also z.B. "neuste Vokabeln").
     * @param vocables
     *            Die anzuzeigenden Vokabeln.
     */
    void listVocablesWithSpecificConstraint(String description, List<Vocable> vocables);

}
