package de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.data;

import de.duehl.swing.ui.components.selections.StringSelection;

/**
 * Diese Klasse stellt eine grammatikalische Form ("Wörterbuchform") zusammen mit einer
 * StringSelection dar, in der der Benutzer eingeben kann, wie die Überschrift der grammatikalischen
 * Tabelle von Verben oder Adjektiven für diese grammatische Form aussehen soll.
 *
 * @version 1.01     2025-11-27
 * @author Christian Dühl
 */

public class GrammarFormAndStringSelection {

    /** Die grammatikalische Form. */
    private final String grammarForm;

    /** Die StringSelection zur Eingabe der eigenen Darstellung. */
    private final StringSelection stringSelection;

    /**
     * Konstruktor.
     *
     * @param grammarForm
     *            Die grammatikalische Form.
     * @param stringSelection
     *            Die StringSelection zur Eingabe der eigenen Darstellung.
     */
    public GrammarFormAndStringSelection(String grammarForm, StringSelection stringSelection) {
        this.grammarForm = grammarForm;
        this.stringSelection = stringSelection;
    }

    /** Getter für die grammatikalische Form. */
    public String getGrammarForm() {
        return grammarForm;
    }

    /** Getter für die StringSelection zur Eingabe der eigenen Darstellung. */
    public StringSelection getStringSelection() {
        return stringSelection;
    }

}
