package de.duehl.vocabulary.japanese.website.update.vocables;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.AbstractDialogBase;
import de.duehl.vocabulary.japanese.common.website.update.UpdateTools;
import de.duehl.vocabulary.japanese.common.website.update.vocables.VocablesActualityChecker;

/**
 * Diese Klasse prüft aus dem Vokabeltrainer selbst heraus, ob neuere Versionen der Vokabeln
 * vorliegen.
 *
 * Diese Klasse wird aus dem Programm aufgerufen, nicht aus dem Launcher und auch nicht zum Startup
 * des Trainers, da das bereits der Launcher erledigt.
 *
 * Vergleiche Klasse
 *     de.duehl.vocabulary.japanese.launcher.update.vocables.VocablesUpdater
 *
 * @version 1.01     2024-12-13
 * @author Christian Dühl
 */

public class VocablesUpdatableChecker {

    /** Der Pfad zu den Vokabularien und den Sound-Files. */
    private final String vocabulariesPath;

    /** Die grafische Oberfläche des Vokabel-Trainers. */
    private final AbstractDialogBase gui;

    /**
     * Konstruktor.
     *
     * @param vocabulariesPath
     *            Der Pfad zu den Vokabularien und den Sound-Files.
     * @param gui
     *            Die grafische Oberfläche des Vokabel-Trainers.
     */
    public VocablesUpdatableChecker(String vocabulariesPath, AbstractDialogBase gui) {
        this.vocabulariesPath = vocabulariesPath;
        this.gui = gui;
    }

    /** Führt die Prüfung durch. */
    public void check() {
        VocablesActualityChecker checker = new VocablesActualityChecker(vocabulariesPath);
        checker.check();
        if (checker.isVersionOnWebserverDetermined()) {
            if (checker.isActual()) {
                String title = "Die Vokabeln sind aktuell";
                String message = "Die Vokabeln sind aktuell.";
                GuiTools.informUserInEdt(gui.getWindowAsComponent(), title, message);
            }
            else {
                String title = "Es gibt neuere Vokabeln auf dem Webserver";
                String message = "Es gibt neuere Vokabeln auf dem Webserver!\n\n"
                        + "Aktuelle Version der Vokabeln: " + checker.getLocalVocableVersion()
                                + "\n"
                        + "Neuere Version der Vokabeln  : " + checker.getWebsiteVocableVersion()
                                + "\n\n"
                        + "Bitte beenden sie den Trainer und starten Sie den Launcher, um die neue "
                        + "Version herunterzuladen.\n"
                        + "Dafür muss das Programm nur neu getsartet werden, dabei startet zuerst "
                        + "der Launcher und anschließend der Vokabeltrainer.";
                GuiTools.informUserInEdt(gui.getWindowAsComponent(), title, message);
            }
        }
        else {
            UpdateTools.informUserAboutDownloadFailure("der Vokabeln", gui.getLocation(),
                    gui.getProgramImage());
        }
    }

}

