package de.duehl.vocabulary.japanese.io;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.util.List;

import org.junit.jupiter.api.Test;

import de.duehl.vocabulary.japanese.data.Vocabulary;

public class VocabularyDirectoryReaderTest {

    @Test
    public void read() {
        String directory = "c:/Users/setup/Daten/sprachen/japanisch/vokabeln";
        VocabularyDirectoryReader reader = new VocabularyDirectoryReader(directory);
        reader.read();
        List<Vocabulary> vocabularies = reader.getVocabularies();
        assertEquals(309, vocabularies.size());

        //VocabularyTools.printVocabularies(vocabularies);

        Vocabulary vocabulary = vocabularies.get(1);
        assertEquals("B1 K02 1 Zählen", vocabulary.getDescription());
    }

}
