package de.duehl.vocabulary.japanese.other;

import java.awt.*;
import javax.swing.*;
import javax.swing.text.JTextComponent;

import de.duehl.swing.ui.GuiTools;

public class NimbusTest extends JFrame {

    private static final long serialVersionUID = 1L;

    //private static final Color BACKGROUND = new Color(232, 232, 255);
    private static final Color BACKGROUND = Color.RED;

    public NimbusTest() {

        JPanel contentPane = new JPanel(new BorderLayout());

        JTextComponent editor = createEditorPane();
        contentPane.add(new JScrollPane(editor));

        setContentPane(contentPane);
        setTitle("Nimbus Test");
        setSize(350, 350);
        setLocationRelativeTo(null);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

    private JTextComponent createEditorPane() {

        // JTextArea editor = new JTextArea();
        JEditorPane editor = new JEditorPane();

        // Comment this out and JEditorPane BG won't be changed for Nimbus
        if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
            Color selFG = editor.getSelectedTextColor();
            Color selBG = editor.getSelectionColor();
            editor.setUI(new javax.swing.plaf.basic.BasicEditorPaneUI());
            editor.setSelectedTextColor(selFG);
            editor.setSelectionColor(selBG);
            // editor.setContentType("text/html");
        }

        editor.setBackground(BACKGROUND);

        editor.setText("This is some sample text");
        return editor;

    }

    /**
     * Program entry point.
     *
     * @param args
     *            Command line arguments.
     */
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> run());
//                new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    // UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
//                    //UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
//                    UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
//                }
//                catch (Exception e) {
//                    e.printStackTrace();
//                }
//                new NimbusTest().setVisible(true);
//            }
//        });

    }

    private static void run() {
        GuiTools.setNiceLayoutManager();
        new NimbusTest().setVisible(true);
    }

}